/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdnxs.dc.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.DateUtils;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Packer;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        String currentPage = this.getCurrentPage();
        int page = currentPage.equals("0") ? 1 : Integer.parseInt(currentPage);
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(bankDetailRequest, page + "", "20"));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = GDNXS_Parser.parserCommonInfo(ebenk);
        Element body = ebenk.getChild("Body");
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element lists = body.getChild("List");
            String count = body.getChildText("TotalCount");
            String recordCount = body.getChildText("RecordCount");
            Integer TotleCount = Integer.parseInt(count);
            if (TotleCount == 0) {
                this.logger.info("\u94f6\u884c\u65e0\u660e\u7ec6\u8fd4\u56de");
                return new EBBankDetailResponse(detailList);
            }
            this.judgeLastPage(recordCount, count);
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            List list = lists.getChildren("Map");
            for (Element row : list) {
                DetailInfo detail = new DetailInfo();
                String payeeAcNo = row.getChildTextTrim("InAcNo");
                String payeeAcName = row.getChildTextTrim("InAcName");
                String InBankName = row.getChildTextTrim("InBankName");
                String HostJnlNo = row.getChildTextTrim("HostJnlNo");
                detail.setOppAccNo(payeeAcNo);
                detail.setOppAccName(payeeAcName);
                detail.setOppBankName(InBankName);
                detail.setAccName(acnt.getAccName());
                detail.setAccNo(acnt.getAccNo());
                String transferDate = row.getChildTextTrim("TransactionDate");
                String TransactionTime = row.getChildTextTrim("TransactionTime");
                LocalDateTime transTime = DateUtils.parseGLBTransTime(transferDate + TransactionTime);
                detail.setTransTime(transTime);
                detail.setTransDate(transTime.toLocalDate());
                String amount = row.getChildTextTrim("Amount");
                String CDFlag = "C";
                if (amount.indexOf("-") != -1) {
                    CDFlag = "D";
                }
                BigDecimal payAmountD = new BigDecimal(amount);
                if ("D".equalsIgnoreCase(CDFlag)) {
                    detail.setDebitAmount(payAmountD.abs());
                    detail.setCreditAmount(new BigDecimal(0));
                } else if ("C".equalsIgnoreCase(CDFlag)) {
                    detail.setDebitAmount(new BigDecimal(0));
                    detail.setCreditAmount(payAmountD.abs());
                }
                String AcctBal = row.getChildTextTrim("Balance");
                detail.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)AcctBal, (Boolean)true));
                String summary = "";
                if (row.getChildTextTrim("Digest") != null) {
                    summary = row.getChildTextTrim("Digest");
                }
                detail.setExplanation(summary);
                detail.setCurrency(bankDetailRequest.getBankCurrency());
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(HostJnlNo);
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transferDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int countInt = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, countInt);
                    receiptNo = receiptNo + "-" + String.format("%04d", countInt);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detailList.add(detail);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.4.1.3\u8d26\u6237\u660e\u7ec6\u67e5\u8be2\uff08\u4ea4\u6613\u7801B2EActTrsQry\uff09", (String)"DetailImpl_1", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]);
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) {
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)DateUtils.getDate(request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)DateUtils.getDate(request.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"BeginNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"RecordNum", (String)page);
        return body;
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/B2EActTrsQry.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }

    private void judgeLastPage(String recordCount, String totalCount) {
        if (StringUtils.isEmpty((String)recordCount) || StringUtils.isEmpty((String)totalCount)) {
            this.logger.info("\u94f6\u884c\u8fd4\u56de\u53c2\u6570recordCount\u4e3a{},totalCount\u4e3a{}\uff0c\u65e0\u6cd5\u5224\u65ad\u672b\u9875", new Object[]{recordCount, totalCount});
            this.setLastPage(true);
            return;
        }
        int recordCountPage = Integer.parseInt(recordCount);
        int totalCountPage = Integer.parseInt(totalCount);
        if (recordCountPage < 20) {
            this.setLastPage(true);
            return;
        }
        String currentPage = this.getCurrentPage();
        int currentPageCount = Integer.parseInt(currentPage) + 1;
        if (currentPageCount + 20 > totalCountPage) {
            this.setLastPage(true);
            return;
        }
        this.logger.info("\u672a\u67e5\u8be2\u5b8c");
        this.setLastPage(false);
        this.setCurrentPage(currentPageCount + 20);
    }

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isChooseGroupDetail() == false;
    }
}

