/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bxw.opa.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.xwbank.sdk.entity.querybalance.QueryBalanceInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWBResponse;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IHisBalance,
IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        String customID = EBContext.getContext().getCustomID();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        try {
            BankAcnt acnt = request.getAcnt();
            String canal = RequestContextUtils.getBankParameterValue((String)"canal");
            String appID = RequestContextUtils.getBankParameterValue((String)"appID");
            LocalDate startDate = request.getStartDate();
            LocalDate endDate = request.getEndDate();
            while (!startDate.isAfter(endDate)) {
                QueryBalanceInfo queryBalanceInfo = new QueryBalanceInfo();
                queryBalanceInfo.setVersion("1.0");
                queryBalanceInfo.setMcht_no(canal);
                queryBalanceInfo.setAcct_no(acnt.getAccNo());
                if (!startDate.isEqual(endDate)) {
                    queryBalanceInfo.setBal_date(startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
                }
                queryBalanceInfo.setAppId(appID);
                XWBResponse response = XWUtil.send(queryBalanceInfo, customID);
                if (response.isSuccess()) {
                    JSONObject data = response.getData();
                    String deal_result = data.getString("deal_result");
                    String return_message = data.getString("return_message");
                    if (!"0".equalsIgnoreCase(deal_result)) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u9519\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), return_message));
                    }
                    String cur_avail_bal = data.getString("cur_avail_bal");
                    String his_avail_bal = data.getString("his_avail_bal");
                    BalanceInfo balanceInfo = new BalanceInfo();
                    balanceInfo.setBankAcnt(request.getAcnt());
                    balanceInfo.setBankCurrency(request.getCurrency());
                    if (startDate.isEqual(endDate)) {
                        balanceInfo.setCurrentBalance(new BigDecimal(cur_avail_bal));
                    } else {
                        balanceInfo.setCurrentBalance(new BigDecimal(his_avail_bal));
                    }
                    balanceInfo.setBalanceDateTime(startDate.atTime(0, 0, 0));
                    balanceInfos.add(balanceInfo);
                    startDate = startDate.plusDays(1L);
                    continue;
                }
                throw EBExceiptionUtil.serviceException((String)response.getResponseMessage());
            }
            return new EBBankBalanceResponse(balanceInfos);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "queryBalance";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean async() {
        return false;
    }
}

