/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.services.payment.salary;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.cms.utils.TCommon;
import kd.ebg.aqap.banks.bbgb.cms.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QrySalPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QrySalPaymentImpl.class);

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "200201";
        String req_no = Sequence.genSequence();
        Element ap = TPacker.createCommonHead(tr_code, req_no);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String d = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)d);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        log.info("---\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2:" + xmlMsg);
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        String content;
        List infos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)infos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(infos);
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570=%s\u3002", (String)"QrySalPaymentImpl_5", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), record_num), (String)"", (String)"");
            return new EBBankPayResponse(infos);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        if ("1".equals(file_flag)) {
            log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u6587\u4ef6'");
            content = "";
        } else {
            log.info("###\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] rs = this.parseRecord(content, recordNum, fieldNum);
        for (int i = 1; i < rs.length; ++i) {
            log.info(String.valueOf(Arrays.asList(rs[i])));
            String ACNO = rs[i][1];
            String ACNAME = rs[i][3];
            String AMT = rs[i][5];
            String SUMMARY = rs[i][6];
            String STAT = rs[i][9];
            String ERR_MSG = rs[i][10];
            String BATCH_NO = rs[i][11];
            PaymentInfo payInfo = this.findPaymentInfo(infos, BATCH_NO, ACNO, ACNAME, AMT);
            if (null == payInfo) continue;
            if ("1".equals(STAT) || "5".equals(STAT) || "6".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalPaymentImpl_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalPaymentImpl_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]));
                continue;
            }
            if ("F".equals(STAT) || "3".equals(STAT) || "4".equals(STAT) || "8".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QrySalPaymentImpl_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("0".equals(STAT) || "2".equals(STAT) || "7".equals(STAT) || "9".equals(STAT) || "A".equals(STAT) || "R".equals(STAT) || "S".equals(STAT) || "Z".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QrySalPaymentImpl_4", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalPaymentImpl_0", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(infos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return null;
    }

    public PaymentInfo findPaymentInfo(List<PaymentInfo> infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {
        String packageId = infos.get(0).getPackageId();
        for (PaymentInfo pay : infos) {
            if (!packageId.equals(BATCH_NO) || !pay.getIncomeAccNo().equals(ACNO) || !pay.getIncomeAccName().equals(ACNAME) || !pay.getAmount().toPlainString().equals(AMT)) continue;
            return pay;
        }
        return null;
    }

    public String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        log.info("###[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

