/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.services.payment.salary;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bbgb.cms.services.payment.salary.QrySalPaymentImpl;
import kd.ebg.aqap.banks.bbgb.cms.utils.TCommon;
import kd.ebg.aqap.banks.bbgb.cms.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(SalPaymentImpl.class);

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        StringBuilder sb = new StringBuilder();
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            paymentInfo = (PaymentInfo)paymentInfos.get(i);
            BigDecimal amt = paymentInfo.getAmount();
            totalAmt = totalAmt.add(amt);
            sb.append(paymentInfo.getIncomeAccNo()).append("|");
            sb.append(paymentInfo.getCurrency()).append("|");
            sb.append(paymentInfo.getIncomeAccName()).append("|");
            sb.append("").append("|");
            String amount = amt.setScale(2, 1).toPlainString();
            sb.append(amount).append("|");
            sb.append(paymentInfo.getExplanation()).append("|");
        }
        String tr_code = "300002";
        Element ap = TPacker.createCommonHead(tr_code, paymentInfo.getPackageId(), "1");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0");
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmt.setScale(2, 1).toPlainString());
        JDomUtils.addChild((Element)body, (String)"count", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        String fileName = paymentInfo.getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = TCommon.parseBankResponse(head);
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44 (300002\u4ea4\u6613)", (String)"SalPaymentImpl_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

