/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        if ("notice".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u901a\u77e5\u4f59\u989d\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4f59\u989d\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        return this.packNormalHisBalance(request);
    }

    public String packNormalHisBalance(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        String accNo = acnt.getAccNo();
        Element body = new Element("body");
        String acctNoFixLength = StringLength.fixed((String)accNo, (String)" ", (int)20, (boolean)false);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acctNoFixLength);
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)rqst.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)rqst.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("4403", signedMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String currency;
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String acctNo = body.getChildText("acctNo");
        if (StringUtils.isEmpty((String)acctNo)) {
            acctNo = request.getAcnt().getAccNo();
        }
        if (StringUtils.isEmpty((String)(currency = body.getChildText("currency")))) {
            currency = request.getBankCurrency();
        }
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        int length = localList.size();
        Object[] balances = new BalanceInfo[length];
        for (int i = 0; i < length; ++i) {
            Element element = (Element)localList.get(i);
            String balanceStr = element.getChildTextTrim("balance");
            BalanceInfo balance = new BalanceInfo();
            this.setBankAcnt(balance, request.getBankAcntList(), acctNo);
            this.setCurrentBalance(balance, balanceStr);
            String transDate = JDomUtils.getChildText((Element)element, (String)"transDate");
            this.setBalanceDateTime(balance, transDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            this.setBankCurrency(balance, request.getBankCurrency(), currency);
            balances[i] = balance;
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])balances));
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(28L);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u6d3b\u671f\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2\uff084403\uff09", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u6d3b\u671f\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 30;
    }
}

