/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance.balanceCheck;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.balance.balanceCheck.QueryBalanceBillImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBalanceCheckDateImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryBalanceCheckDateImpl.class);

    public int getMonthSpan() {
        return 1;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        Element body = new Element("body");
        String accNo = bankBalanceStatementRequest.getAccNo();
        String transMasterID = BankBusinessConfig.getPayMasterID(accNo);
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transMasterID);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        String startMonth = bankBalanceStatementRequest.getStartMonth();
        String beginDate = startMonth + "01";
        LocalDate localDate = LocalDateUtil.parserDate((String)beginDate, (String)"yyyyMMdd");
        int lastDay = localDate.lengthOfMonth();
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)beginDate);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)(startMonth + lastDay));
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"50");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        log.info("\u7b7e\u540d\u524d\u62a5\u6587==" + srcSign);
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("FW47", signedMsg);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String responseStr) {
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u8d26\u671f\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"QueryBalanceCheckDateImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        Element element = (Element)localList.get(0);
        String checkDate = element.getChildText("checkDate");
        String checkNo = element.getChildText("checkNo");
        RequestContextUtils.setRunningParam((String)"checkDate", (String)checkDate);
        QueryBalanceBillImpl queryBalanceBill = new QueryBalanceBillImpl();
        EBBankBalanceStatementResponse ebBankBalanceStatementResponse = queryBalanceBill.doBiz(bankBalanceStatementRequest);
        ebBankBalanceStatementResponse.getDetails().forEach(detail -> detail.setStatementNo(checkNo));
        return ebBankBalanceStatementResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "FW47";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u8d26\u671f\u67e5\u8be2", (String)"QueryBalanceCheckDateImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

