/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.another;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.another.PayContentUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "AQ54";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"AQ54\u4ee3\u6536\u4ee3\u4ed8\u660e\u7ec6\u7ed3\u679c\u67e5\u8be2\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        String accNo = info.getAccNo();
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(accNo));
        JDomUtils.addChild((Element)body, (String)"projectNumber", (String)BankBusinessConfig.getProjectNumber(accNo));
        JDomUtils.addChild((Element)body, (String)"costItemCode", (String)BankBusinessConfig.getFeeNo(accNo));
        JDomUtils.addChild((Element)body, (String)"transDate", (String)info.getSubmitSuccessTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"handleSeqNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"electronNumber", (String)paymentInfos[0].getBankBatchSeqId());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg(this.getBizCode(), signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            Element lists = JDomUtils.getChildElement((Element)body, (String)"lists");
            List list = lists.getChildren("list");
            if (list.size() == 0) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7ed3\u679c\u96c6\u4e3a\u7a7a\u8bf7\u7a0d\u540e\u518d\u67e5\u3002", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"");
            } else {
                Map<String, BankResponseResult> resultMap = PayContentUtils.parseResult(list);
                for (PaymentInfo info : paymentInfos) {
                    String key = info.getBankDetailSeqId();
                    BankResponseResult result = resultMap.get(key);
                    if (null == result) continue;
                    if (result.isFailed()) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)result.getResponseCode(), (String)result.getBankMessage());
                        continue;
                    }
                    if (result.isSuccess()) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)result.getResponseCode(), (String)result.getBankMessage());
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\u8bf7\u7a0d\u540e\u518d\u67e5\u6216\u4e0e\u94f6\u884c\u8054\u7cfb\u67e5\u8be2\u7ed3\u679c\u3002", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)result.getBankMessage());
                }
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

