/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.CommonUtils;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayImpl.class);
    private String testResponse = "<?xml version='1.0' encoding='GB2312'?>\n<packet>\n    <head>\n        <transCode>5630</transCode>\n        <signFlag>0</signFlag>\n        <packetID>1234567890</packetID>\n        <timeStamp>2020-07-28 16:14:29</timeStamp>\n        <returnCode>AAAAAAA</returnCode>\n        <returnMsg>test</returnMsg>\n    </head>\n</packet>\n";
    private static final int pageSize = 200;
    private static final String PAYERACCNO = "payerAccNo";
    private static final String SUBMINTEDDATE = "submintedDate";
    private static final String TOTALNUMBER = "totalNumber";
    private static final String TOTALAMOUNTSTR = "totalAmountStr";

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "5630";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"10.1 5652\u4ee3\u53d1\u5de5\u8d44\u6587\u4ef6\u63d0\u4ea4/\u9884\u6821\u9a8c;10.2 5626 \u4ee3\u53d1\u5de5\u8d44\u4fe1\u606f\u67e5\u8be2;10.3 5630\u4ee3\u53d1\u5de5\u8d44\u6587\u4ef6\u63d0\u4ea4/\u9884\u6821\u9a8c\u7ed3\u679c\u4fe1\u606f\u67e5\u8be2", (String)"QueryPayImpl_16", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String entrustSeqNo = Packer.getEntrustSeqNo(paymentInfos[0]);
        String bizSeqId = request.getHeader().getBizSeqID();
        if (!StringUtils.isEmpty((String)entrustSeqNo)) {
            return super.queryPay(request);
        }
        PaymentInfo[] tempPays = PaymentInfoService.getInstance().selectByBatchSeqID(paymentInfos[0].getBatchSeqID()).toArray(new PaymentInfo[0]);
        if (null == tempPays || 0 == tempPays.length) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u6b65\u72b6\u6001\uff0c\u94f6\u4f01\u4e91\u6570\u636e\u5e93\u4e2d\u672a\u627e\u5230\u6279\u6b21\u6d41\u6c34\u4e3a%s\u7684\u652f\u4ed8\u5355\u3002", (String)"QueryPayImpl_29", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), paymentInfos[0].getBatchSeqID());
            log.info(errorMsg);
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)errorMsg, (String)"", (String)"");
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        int len = tempPays.length;
        String payerAccNo = tempPays[0].getAccNo();
        String submintedDate = tempPays[0].getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE);
        String totalNumber = String.valueOf(len);
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < len; ++i) {
            totalAmt = totalAmt.add(tempPays[i].getAmount());
        }
        tempPays = null;
        String totalAmountStr = totalAmt.setScale(2, 4).toString();
        HashMap<String, String> conditionMap = new HashMap<String, String>(16);
        conditionMap.put(PAYERACCNO, payerAccNo);
        conditionMap.put(SUBMINTEDDATE, submintedDate);
        conditionMap.put(TOTALNUMBER, totalNumber);
        conditionMap.put(TOTALAMOUNTSTR, totalAmountStr);
        entrustSeqNo = this.getPayStateFrom5626(bizSeqId, paymentInfos, conditionMap);
        if (!StringUtils.isEmpty((String)entrustSeqNo)) {
            Packer.setEntrustSeqNo(paymentInfos, entrustSeqNo);
            log.info("\u4ee3\u53d1\u5de5\u8d44\u4fe1\u606f\u67e5\u8be2(5626),\u67e5\u8be2\u5230\u6279\u6b21\u6d41\u6c34=" + paymentInfos[0].getPackageId() + "\u5bf9\u5e94\u7684'\u4e1a\u52a1\u59d4\u6258\u7f16\u53f7'=" + entrustSeqNo);
            return super.queryPay(request);
        }
        String msg = String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4fe1\u606f\u67e5\u8be2(5626),\u65e0\u6cd5\u67e5\u8be2\u5230\u6279\u6b21\u6d41\u6c34=%s\u5bf9\u5e94\u7684'\u4e1a\u52a1\u59d4\u6258\u7f16\u53f7',\u6240\u4ee5\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"QueryPayImpl_30", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), paymentInfos[0].getPackageId());
        log.info(msg);
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)msg, (String)"", (String)"");
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getPayStateFrom5626(String bizSeqId, PaymentInfo[] paymentInfos, Map<String, String> conditionMap) {
        int[] page = new int[]{1, 0};
        String entrustSeqNo = "";
        while (true) {
            String reqMsg = this.pack5626(paymentInfos, conditionMap.get(SUBMINTEDDATE), page);
            String rspMsg = this.sendAndRcv4Query(reqMsg, bizSeqId);
            EBContext context = EBContext.getContext();
            boolean unitTest = context.isUnitTest();
            if (unitTest) {
                rspMsg = this.testResponse;
            }
            if (!StringUtils.isEmpty((String)(entrustSeqNo = this.parse5626(paymentInfos, rspMsg, conditionMap, page))) || page[1] < 200) break;
            page[0] = page[0] + 200;
        }
        return entrustSeqNo;
    }

    public String pack5626(PaymentInfo[] paymentInfos, String transDate, int[] page) {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element body = new Element("body");
        String unitNo = "";
        if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            unitNo = BankBusinessConfig.getUnitNo(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"QueryPayImpl_21", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            unitNo = BankBusinessConfig.getUnitNoOther(paymentInfo.getAccNo());
            if (StringUtils.isEmpty((String)unitNo)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5176\u4ed6\u4e1a\u52a1\u7684\u2018\u5355\u4f4d\u7f16\u53f7\u2019\u4e0d\u80fd\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u83b7\u53d6\u5e76\u5728\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"QueryPayImpl_22", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            }
        }
        JDomUtils.addChild((Element)body, (String)"unitNo", (String)unitNo.trim());
        JDomUtils.addChild((Element)body, (String)"transDate", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)String.valueOf(page[0]));
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)String.valueOf(200));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("5626", signedMsg);
    }

    public String parse5626(PaymentInfo[] paymentInfos, String rspMsg, Map<String, String> conditionMap, int[] page) {
        BankResponse rsp = ParserRsp.parseRsp(rspMsg);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            int length;
            String rspData = Signature.getInstance().validateSignedData(rspMsg);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            Element listsElement = body.getChild("lists");
            if (null == listsElement) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blists\u8282\u70b9\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_10", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return null;
            }
            List rdList = listsElement.getChildren("list");
            if (null == rdList || 0 == rdList.size()) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blist\u8282\u70b9\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_11", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return null;
            }
            page[1] = length = rdList.size();
            for (int i = 0; i < length; ++i) {
                Element rd = (Element)rdList.get(i);
                String entrustSeqNo = rd.getChildTextTrim("entrustSeqNo");
                String acctNo = rd.getChildTextTrim("acctNo");
                String totalNumber = rd.getChildTextTrim(TOTALNUMBER);
                String totalAmount = rd.getChildTextTrim("totalAmount");
                String transDate = rd.getChildTextTrim("transDate");
                BigDecimal formatedAmount = BigDecimalHelper.str2BigDecimal((String)totalAmount);
                String amoutStr = BigDecimalHelper.plain2((BigDecimal)formatedAmount);
                if (!conditionMap.get(PAYERACCNO).equalsIgnoreCase(acctNo) || !conditionMap.get(SUBMINTEDDATE).equalsIgnoreCase(transDate) || !conditionMap.get(TOTALNUMBER).equalsIgnoreCase(totalNumber) || !conditionMap.get(TOTALAMOUNTSTR).equalsIgnoreCase(amoutStr) || StringUtils.isEmpty((String)entrustSeqNo)) continue;
                return entrustSeqNo;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String sendAndRcv4Query(String sendMsg, String bizSeqId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"entrustSeqNo", (String)Packer.getEntrustSeqNo(paymentInfos[0]));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("5630", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String acctNo = body.getChildTextTrim("acctNo");
            String transStatus = body.getChildTextTrim("transStatus");
            String msg = ParserRsp.getStatusMsg(transStatus);
            if (!"5".equalsIgnoreCase(transStatus)) {
                if ("0".equalsIgnoreCase(transStatus) || "1".equalsIgnoreCase(transStatus) || "2".equalsIgnoreCase(transStatus) || "4".equalsIgnoreCase(transStatus) || "J".equalsIgnoreCase(transStatus) || "K".equalsIgnoreCase(transStatus) || "A".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_23", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)msg);
                } else if ("3".equalsIgnoreCase(transStatus) || "6".equalsIgnoreCase(transStatus) || "7".equalsIgnoreCase(transStatus) || "G".equalsIgnoreCase(transStatus) || "H".equalsIgnoreCase(transStatus) || "I".equalsIgnoreCase(transStatus) || "Y".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)transStatus, (String)msg);
                } else if ("E".equalsIgnoreCase(transStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryPayImpl_24", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)transStatus, (String)msg);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u72b6\u6001transStatus=%s\u3002", (String)"QueryPayImpl_31", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), transStatus), (String)transStatus, (String)msg);
                }
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            log.info("\u51c6\u5907\u5f00\u59cb\u89e3\u6790\u4ed8\u6b3e\u660e\u7ec6");
            Element listsElement = body.getChild("lists");
            if (null == listsElement) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blists\u8282\u70b9\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_10", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            List rdList = listsElement.getChildren("list");
            if (null == rdList || 0 == rdList.size()) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2d\u672a\u5305\u542blist\u8282\u70b9\uff0c\u65e0\u6cd5\u83b7\u5f97\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"QueryPayImpl_11", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            List paymentInfoAll = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
            request.setPaymentInfos(paymentInfoAll);
            List handPaymentInfos = request.getPaymentInfos();
            int length = rdList.size();
            for (int i = 0; i < length; ++i) {
                Element rd = (Element)rdList.get(i);
                String payeeAcctNo = rd.getChildTextTrim("payeeAcctNo");
                String payeeName = rd.getChildTextTrim("payeeName");
                String amount = rd.getChildTextTrim("amount");
                String note = rd.getChildTextTrim("note");
                String message = rd.getChildTextTrim("message");
                PaymentInfo info = QueryPayImpl.findPaymentInfo(handPaymentInfos.toArray(new PaymentInfo[handPaymentInfos.size()]), payeeAcctNo, payeeName, amount, note);
                if (null == info) continue;
                this.handlePayStatus(info, message);
            }
            PayStatusMatchUtil.preBatchSameItemCheck((List)handPaymentInfos, (boolean)false, (boolean)true);
            this.processingBankItemDataHandler(rdList, handPaymentInfos);
            PayStatusMatchUtil.backBatchSameItemHandler((List)handPaymentInfos, (boolean)false, (boolean)true);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private void processingBankItemDataHandler(List<Element> rdList, List<PaymentInfo> paymentInfos) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element rd : rdList) {
                    String bankDataKey;
                    String payeeAcctNo = rd.getChildTextTrim("payeeAcctNo");
                    String payeeName = rd.getChildTextTrim("payeeName");
                    String amount = rd.getChildTextTrim("amount");
                    String note = rd.getChildTextTrim("note");
                    String message = rd.getChildTextTrim("message");
                    PaymentInfo paymentInfo = QueryPayImpl.findPaymentInfo(paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]), payeeAcctNo, payeeName, amount, note);
                    if (paymentInfo == null || !HashSetKeys.contains(bankDataKey = PayStatusMatchUtil.getKeyByPaymentInfo((PaymentInfo)paymentInfo, (boolean)false, (boolean)true))) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, message);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private void handlePayStatus(PaymentInfo tempInfo, String message) {
        if (message == null) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u62a5\u6587\u672a\u8fd4\u56de<message>\u8282\u70b9\u3002", (String)"QueryPayImpl_26", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u62a5\u6587\u672a\u8fd4\u56de<message>\u8282\u70b9\u3002", (String)"QueryPayImpl_26", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        } else if (message.trim().length() == 0) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)message);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)message);
        }
    }

    public static PaymentInfo findPaymentInfo(PaymentInfo[] payInfos, String incomeAccNo, String incomeName, String amount, String explanation) {
        if (null == payInfos || payInfos.length < 1) {
            return null;
        }
        BigDecimal formatedAmount = BigDecimalHelper.str2BigDecimal((String)amount);
        String amoutStr = BigDecimalHelper.plain2((BigDecimal)formatedAmount);
        formatedAmount = BigDecimalHelper.str2BigDecimal((String)amoutStr);
        int len = payInfos.length;
        for (int i = 0; i < len; ++i) {
            if (!payInfos[i].getIncomeAccNo().equalsIgnoreCase(incomeAccNo) || !payInfos[i].getAmount().equals(formatedAmount) || !CommonUtils.getExplanationForSalaryQuery(payInfos[i]).equalsIgnoreCase(explanation)) continue;
            return payInfos[i];
        }
        return null;
    }
}

