/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.ResponseChecker;
import kd.ebg.aqap.banks.boimc.dc.service.utils.DateFormatter;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        if (bankBalanceRequest == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u7684\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EActBalQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateFormatter.format2DateTime(new Date()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        if (bankAcnt == null || bankAcnt.getAccNo() == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u4e1a\u52a1\u7f3a\u5c11\u8d26\u53f7\u4fe1\u606f\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        this.logger.info("\u8d26\u53f7\uff1a" + bankAcnt.getAccNo());
        Element map = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankAcnt.getAccNo());
        String reqMsg = JDomUtils.root2String((Element)message, (String)"GBK");
        return reqMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        String inputBankCurr = bankBalanceRequest.getBankCurrency();
        BalanceInfo balanceInfo = new BalanceInfo();
        Element root = JDomUtils.string2Root((String)rspStr, (String)"GBK");
        ResponseChecker.checkResponse(root, "");
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElementNotNull((Element)body, (String)"List");
        List childList = list.getChildren();
        if (childList == null || childList.size() == 0) {
            this.logger.error("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u7ed3\u679c\u6570\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u4e3a\u7a7a\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        Element element = (Element)childList.get(0);
        String acNo = JDomUtils.getChildTextNotNull((Element)element, (String)"AcNo");
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acNo);
        String returnCode = JDomUtils.getChildTextNotNull((Element)element, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        String returnMsg = JDomUtils.getChildTextNotNull((Element)element, (String)"ReturnMsg", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u6d88\u606f", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        if (!"000000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)returnCode, (String)returnMsg));
        }
        String currency = JDomUtils.getChildTextNotNull((Element)element, (String)"Currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        String balance = JDomUtils.getChildTextNotNull((Element)element, (String)"Balance", (String)ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d", (String)"BalanceImpl_9", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        String availBal = JDomUtils.getChildTextNotNull((Element)element, (String)"AvailBal", (String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"BalanceImpl_10", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, availBal);
        this.setBankCurrency(balanceInfo, currency);
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        balances.add(balanceInfo);
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_14", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]);
    }
}

