/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.detail.SingleDetailInfo;
import kd.ebg.aqap.banks.shrcb.dc.services.detail.SingleDetialImpl;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.banks.shrcb.dc.utils.Packer;
import kd.ebg.aqap.banks.shrcb.dc.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        String sessionId = new LoginImpl().getSessionID();
        Element root = Packer.createCommonHead("0003", sessionId);
        ArrayList bodyList = new ArrayList(1);
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>(16);
        param.put("AcctNo", request.getAcnt().getAccNo());
        param.put("AcctCurr", request.getBankCurrency());
        param.put("StartDate", request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        param.put("EndDate", request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        int page = Integer.parseInt(this.getCurrentPage());
        int currentCount = 1 + page * 10;
        param.put("CurrentCount", String.valueOf(currentCount));
        param.put("version", "2");
        bodyList.add(param);
        Packer.addBody(root, bodyList);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        this.parsePageTag(root, response);
        if (!"000000".equals(response.getResponseCode())) {
            if ("SE50031".equals(response.getResponseCode())) {
                return new EBBankDetailResponse(detailInfoList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u4ee3\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("body");
        if (null == body) {
            return new EBBankDetailResponse(detailInfoList);
        }
        String acct_no = body.getChildTextTrim("acct_no");
        if (!request.getAcnt().getAccNo().equalsIgnoreCase(acct_no)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0d\u7b26\u3002", (String)"DetailImpl_10", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), acct_no, request.getAcnt().getAccNo()));
        }
        Element tran_record = body.getChild("tran_record_list");
        List recordList = tran_record.getChildren("record");
        if (recordList == null || recordList.size() == 0) {
            return new EBBankDetailResponse(detailInfoList);
        }
        for (int i = 0; i < recordList.size(); ++i) {
            Element record = (Element)recordList.get(i);
            String tran_date = record.getChildTextTrim("tran_date");
            String tran_time = record.getChildTextTrim("tran_time");
            String tran_amount = record.getChildTextTrim("tran_amount");
            String cd_flag = record.getChildTextTrim("cd_flag");
            String balance = record.getChildTextTrim("balance");
            String OppAcctNo = record.getChildTextTrim("payee_account_no");
            String OppAccName = record.getChildTextTrim("payee_account_name");
            String remark = record.getChildTextTrim("remark");
            String seq_No = record.getChildTextTrim("seq_No");
            String uuid = record.getChildTextTrim("uuid");
            String coreSerialNum = record.getChildTextTrim("core_Serial_Num");
            String transNo = record.getChildTextTrim("trans_No");
            String dateFlag = record.getChildTextTrim("date_Flag");
            String summaryCode = record.getChildTextTrim("summary_Code");
            String channelFlag = record.getChildTextTrim("channel_Flag");
            String accountNo = record.getChildTextTrim("account_No");
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(request.getAcnt().getAccNo());
            detail.setAccName(request.getAcnt().getAccName());
            detail.setCurrency(request.getBankCurrency());
            if ("0".equalsIgnoreCase(cd_flag)) {
                detail.setOppAccNo(OppAcctNo);
                detail.setOppAccName(OppAccName);
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(new BigDecimal(tran_amount));
            } else if ("1".equalsIgnoreCase(cd_flag)) {
                detail.setCreditAmount(new BigDecimal(tran_amount));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%1$s\u3002", (String)"DetailImpl_11", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), cd_flag));
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            detail.setExplanation(remark);
            if (!StringUtils.isEmpty((String)tran_date)) {
                detail.setTransDate(LocalDate.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                try {
                    if (StringUtils.isEmpty((String)tran_time)) {
                        detail.setTransTime(LocalDateTime.parse(tran_date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    }
                    detail.setTransTime(LocalDateTime.parse(tran_date + tran_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u7684\u660e\u7ec6\u62a5\u6587\u89e3\u6790\uff0c\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a%1$s\u3002", (String)"DetailImpl_12", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_7", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(coreSerialNum);
            if (StringUtils.isEmpty((String)detail.getOppAccNo()) || StringUtils.isEmpty((String)detail.getOppAccName())) {
                SingleDetailInfo singleDetail = new SingleDetailInfo();
                singleDetail.setTransDate(tran_date);
                singleDetail.setTranAmount(tran_amount);
                singleDetail.setRemark(remark);
                singleDetail.setCoreSerialNum(coreSerialNum);
                singleDetail.setSeqNo(seq_No);
                singleDetail.setChannelFlag(channelFlag);
                singleDetail.setSummaryCode(summaryCode);
                singleDetail.setAccountNo(accountNo);
                singleDetail.setUuid(uuid);
                singleDetail.setTransNo(transNo);
                singleDetail.setDataFlag(dateFlag);
                singleDetail.setCdFlag(cd_flag);
                new SingleDetialImpl().completeOppAcntInfo(singleDetail, detail);
            }
            detailInfoList.add(detail);
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    private void parsePageTag(Element root, BankResponse response) {
        if ("SE50031".equals(response.getResponseCode())) {
            this.setLastPage(true);
            return;
        }
        Element body = root.getChild("body");
        if (null == body) {
            this.setLastPage(true);
            return;
        }
        Element tran_record = body.getChild("tran_record_list");
        List recordList = tran_record.getChildren("record");
        if (recordList == null || recordList.isEmpty()) {
            this.setLastPage(true);
            return;
        }
        int totalCount = Integer.parseInt(body.getChildTextTrim("total_count"));
        int currentNum = 10 * (Integer.parseInt(this.getCurrentPage()) + 1);
        if (currentNum >= totalCount) {
            this.setLastPage(true);
            return;
        }
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "0003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_8", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
        factory.setHttpHeader("Content-Encoding", "utf-8");
    }
}

