/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.services.payment.salary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.banks.shrcb.dc.services.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.shrcb.dc.utils.Packer;
import kd.ebg.aqap.banks.shrcb.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bf9\u79c1\u4ed8\u6b3e\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]));
        }
        PaymentInfo payInfo = (PaymentInfo)paymentInfos.get(0);
        String sessionId = new LoginImpl().getSessionID();
        Element root = Packer.createCommonHead("0012", sessionId, payInfo.getBankDetailSeqId());
        ArrayList bodyList = new ArrayList();
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("PayerAcctNo", payInfo.getAccNo());
        param.put("PayeeAcctName", payInfo.getIncomeAccName());
        param.put("PayeeAcctNo", payInfo.getIncomeAccNo());
        param.put("CardFlag", "2");
        param.put("PayCurr", payInfo.getCurrency());
        param.put("PayAmount", payInfo.getAmount().toString());
        param.put("PayUsage", payInfo.getExplanation());
        bodyList.add(param);
        Packer.addBody(root, bodyList);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Parser.parsePayRsp(paymentInfos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "0012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        return "pay".equals(subBizType) && paymentInfo.is2Individual() || "pay_for_salary".equals(subBizType) || "pay".equals(subBizType) && UseConvertor.isSalary((PaymentInfo)paymentInfo);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
        factory.setHttpHeader("Content-Encoding", "utf-8");
    }
}

