/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.detail.TodayDetailImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final String SEPARATOR = "#";
    private static final String CIRCLE_STR = "|";

    public boolean isTodayDetailReverse() {
        return true;
    }

    public boolean isHistoryDetailReverse() {
        return true;
    }

    public String pack(BankDetailRequest request) {
        BankAcnt bankAcnt = request.getAcnt();
        String reqMsg = "xhj8012#" + bankAcnt.getAccNo() + SEPARATOR + request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + SEPARATOR + request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "###@@@@";
        return reqMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        BankAcnt bankAcnt = request.getAcnt();
        String accNo = bankAcnt.getAccNo();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        String[] elements = TodayDetailImpl.parseResponseEx(responseStr);
        if (!accNo.equalsIgnoreCase(elements[1])) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff1b", (String)"DetailImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), accNo, elements[1]));
        }
        int count = Integer.parseInt(elements[2]);
        String[] fields = null;
        int elemtIndex = 3;
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)6);
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), "xhj8012");
        for (int i = 0; i < count; ++i) {
            DetailInfo detailInfo = new DetailInfo();
            JSONObject detailJson = new JSONObject();
            String record = elements[elemtIndex++];
            fields = StringUtils.split((String)record, (String)CIRCLE_STR);
            detailInfo.setOppBankName(fields[9]);
            String date = fields[1];
            String tranSerialNo = fields[4];
            String JDcode = fields[5];
            String transactionMoney = fields[6];
            String otherAccNo = fields[7];
            detailInfo.setOppAccNo(fields[7]);
            detailInfo.setOppAccName(fields[8]);
            detailInfo.setTransDate(LocalDate.parse(fields[1], DateTimeFormatter.ofPattern("yyyyMMdd")));
            detailInfo.setTransTime(LocalDateTime.parse(fields[1] + fields[2], DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss")));
            detailInfo.setCurrency(fields[3]);
            String json = null;
            if (detailField != null) {
                json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), record + CIRCLE_STR, detailField.getSplit());
            }
            if (StringUtils.isNotEmpty(json)) {
                detailJson = JSON.parseObject(json);
            }
            detailJson.put("transDate", (Object)fields[1]);
            detailJson.put("transTime", (Object)fields[2]);
            detailJson.put("money", (Object)fields[6]);
            detailJson.put("accNo", (Object)request.getHeader().getAcnt());
            detailJson.put("tranSerialNo", (Object)tranSerialNo);
            if (BankBusinessConfig.isFileReceipt()) {
                detailJson.remove((Object)"oppAccNo", (Object)otherAccNo);
            }
            detailJson.put("cdFlag", (Object)fields[5]);
            detailJson.put("serialNo", (Object)tranSerialNo);
            BigDecimal amount = new BigDecimal(fields[6]);
            boolean payFlag = false;
            if ("1".equalsIgnoreCase(fields[5])) {
                payFlag = true;
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(amount);
            } else if ("2".equalsIgnoreCase(fields[5])) {
                detailInfo.setCreditAmount(amount);
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u501f\u8d37\u6807\u8bb0:%s\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u501f\u8d37\u65b9\u5411\u3002", (String)"DetailImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), fields[5]));
            }
            if (StringUtils.isNotEmpty((String)fields[10])) {
                detailInfo.setBalance(new BigDecimal(fields[10]));
            }
            if (payFlag && !StringUtils.isEmpty((String)fields[11]) && fields[11].indexOf("_KD_") != -1) {
                String KDDetailNo = Packer.parseKDDetailNo(fields[11]);
                String exp = Packer.parseKDExp(fields[11]);
                detailInfo.setExplanation(exp);
                detailInfo.setKdFlag(KDDetailNo);
                detailInfo.setPayBankDetailSeqID(KDDetailNo);
            } else {
                detailInfo.setExplanation(fields[11] + "," + fields[12]);
                if (detailInfo.getExplanation().length() == 1 && detailInfo.getExplanation().contains(",")) {
                    detailInfo.setExplanation("");
                } else if (detailInfo.getExplanation().endsWith(",")) {
                    detailInfo.setExplanation(detailInfo.getExplanation().substring(0, detailInfo.getExplanation().length() - 1));
                } else if (detailInfo.getExplanation().startsWith(",")) {
                    detailInfo.setExplanation(detailInfo.getExplanation().substring(1));
                }
            }
            String receiptNo = date + tranSerialNo + JDcode + transactionMoney + otherAccNo;
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"receiptNo", (String)receiptNo);
            if (BankBusinessConfig.isUseNewMatchRule(request.getAcnt().getBankLoginId(), RequestContext.get().getTenantId())) {
                receiptNo = MatchRule.getInstance().getReceiptNo(accNo, date, detailJson.toJSONString());
                if (countMap.containsKey(receiptNo)) {
                    int countInt = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, countInt);
                    receiptNo = receiptNo + "-" + String.format("%04d", countInt);
                } else {
                    countMap.put(receiptNo, 0);
                }
            }
            ResponseStrUtil.check(detailJson, record);
            detailInfo.setBankDetailNo(tranSerialNo);
            detailInfo.setReceiptNo(receiptNo);
            detailJson.put("oppAccNo", (Object)otherAccNo);
            detailInfo.setJsonMap(detailJson.toJSONString());
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "xhj8012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6", (String)"DetailImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.is8012Ifaze();
    }
}

