/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.singlepay;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.company.outterBank.OutterBankQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;

public class XHJ8016Impl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OutterBankQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        ArrayList<String> req = new ArrayList<String>(16);
        req.add(this.getBizCode());
        req.add(paymentInfo.getBankBatchSeqID());
        String testTime = EBContext.getContext().getParameter().getBankParameter("TEST_TIME");
        if (!StringUtils.isEmpty((String)testTime)) {
            req.add(testTime);
        } else {
            req.add(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        req.add("");
        req.add(paymentInfo.getAccNo());
        req.add(" ");
        req.add(paymentInfo.getAmount().toString());
        req.add(paymentInfo.is2Individual() ? "1" : "0");
        if (paymentInfo.is2SameBank()) {
            req.add("4");
        } else if ("big".equalsIgnoreCase(BankBusinessConfig.getTransChannal())) {
            req.add("0");
        } else if ("same".equalsIgnoreCase(BankBusinessConfig.getTransChannal())) {
            req.add("1");
        } else {
            req.add("3");
        }
        req.add(paymentInfo.getIncomeAccNo());
        req.add(paymentInfo.getIncomeAccName());
        req.add(paymentInfo.getIncomeCnaps());
        req.add(paymentInfo.getIncomeBankName());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            if (!StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
                req.add(Packer.getKDExp(paymentInfo));
            } else {
                req.add(Packer.getKDExp(paymentInfo, ""));
            }
        } else {
            req.add(paymentInfo.getExplanation());
        }
        req.add(" ");
        req.add(" ");
        req.add(" ");
        req.add("@@@@");
        return String.join((CharSequence)String.valueOf('#'), req);
    }

    public EBBankPayResponse parse(BankPayRequest request, String s) {
        s = ResponseStrUtil.process(s);
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String[] elements = StringUtils.split((String)s, (String)"#");
        String responseCode = elements[0];
        String responseMsg = elements.length > 2 ? String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u7aef\u6d41\u6c34\u53f7:%1$s;\u5907\u7528\u57df1:%2$s\u3002", (String)"InnerBankPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[1], elements[2]) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"InnerBankPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0]);
        if ("000000".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"InnerBankPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"", (String)"");
        } else if ("EL4114".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"InnerBankPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"InnerBankPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"InnerBankPayImpl_9", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "xhj8016";
    }

    public String getBizDesc() {
        return "xhj8016";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

