/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.login;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.aqap.banks.srcb.dc.services.Parser;
import kd.ebg.aqap.banks.srcb.dc.services.login.LoginPacker;
import kd.ebg.aqap.banks.srcb.dc.services.utils.DecryUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.SmUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LoginImpl
extends AbstractImpl {
    private EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private LoginPacker loginPacker = new LoginPacker();
    private String token = "";

    public String getToken() {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get((String)key);
        boolean unitTest = EBContext.getContext().isUnitTest();
        if (unitTest) {
            return "testToken";
        }
        if (StringUtils.isEmpty((String)cache_token)) {
            DLock lock = DLock.create((String)key, (String)ResManager.loadKDString((String)"\u6df1\u5733\u519c\u5546\u884c\u83b7\u53d6\u767b\u5f55token\u5206\u5e03\u5f0f\u9501\u3002", (String)"LoginImpl_0", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
            try {
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get((String)key);
                    if (cache_token == null) {
                        this.login();
                        cache_token = this.token;
                    }
                } else {
                    long time;
                    for (time = 180000L; time >= 0L && (cache_token = CosmicCache.get((String)key)) == null; time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"LoginImpl_1", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                this.log.error(String.format("\u83b7\u53d6\u6df1\u5733\u519c\u5546\u884ctoken\u51fa\u73b0\u5f02\u5e38,%s", e.getMessage()));
                throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return cache_token;
    }

    public void login() {
        try {
            String rqstStr = this.loginPacker.packLogin();
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
            factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
            IConnection conn = factory.createExchangeConnection();
            this.openConnection(conn);
            try (OutputStream outputStream = conn.getOutputStream();){
                this.send(outputStream, rqstStr);
                this.closeOutputStreamQuietly(outputStream);
                try (InputStream inputStream = conn.getInputStream();){
                    String rspStr = this.recv(inputStream);
                    IOUtils.closeInputStreamQuietly((InputStream)inputStream);
                    String decry = DecryUtil.decry(rspStr);
                    boolean verify = SmUtil.verify(decry);
                    if (!verify) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u4e0d\u901a\u8fc7\u3002", (String)"LoginImpl_2", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
                    }
                    this.token = this.parseLogin(decry);
                    this.closeInputStreamQuietly(inputStream);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    public String parseLogin(String rspStr) {
        String realResponseMsg = Parser.getRealResponseMsg(rspStr);
        Element root = JDomUtils.string2Root((String)realResponseMsg, (String)RequestContextUtils.getCharset());
        Element envelope = root.getChild("Envelope");
        Element header = envelope.getChild("Header");
        Element body = envelope.getChild("Body");
        String resultCode = header.getChildTextTrim("ResultCode");
        String resultMessage = header.getChildTextTrim("ResultMessage");
        if (!"000000".equalsIgnoreCase(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"LoginImpl_7", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]), resultCode, resultMessage));
        }
        String token = body.getChildText("Token");
        if (StringUtils.isEmpty((String)token)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56detoken\u4e3a\u7a7a\u3002", (String)"LoginImpl_5", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
        }
        String expiredIn = body.getChildText("ExpiredIn");
        if (StringUtils.isEmpty((String)expiredIn)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56detoken\u5931\u6548\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"LoginImpl_6", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
        }
        int value = Integer.parseInt(expiredIn);
        this.log.info("\u94f6\u884c\u8fd4\u56detoken\u8fc7\u671f\u65f6\u95f4:{}", (Object)value);
        if (value == -1) {
            value = 86400;
        }
        CosmicCache.putIfAbsentWithExpire((String)this.getCacheKey(), (String)token, (int)value, (TimeUnit)TimeUnit.SECONDS);
        return token;
    }

    public String getCacheKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginID = EBContext.getContext().getBankLoginID();
        return "eb_" + customID + "_" + bankLoginID + "_token";
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }
}

