/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HistoryDetailImpl.class);

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "queryHistoryCurrentList1_1Op";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6", (String)"HistoryDetailImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest request) {
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"QSRQ", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)reqParam, (String)"ZZRQ", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)reqParam, (String)"MIFS", (String)"0");
        JDomUtils.addChild((Element)reqParam, (String)"MAFS", (String)"9999999999.99");
        String packAll = Packer.packAllInOne(Sequence.gen18Sequence(), reqParam);
        packAll = packAll.replaceAll("\r", "").replaceAll("\n", "");
        String session = LoginAndOut.login4GetSession();
        String opName = "queryHistoryCurrentList1_1Op";
        if (BankBusinessConfig.isChooseFzDetail()) {
            opName = "queryHistoryCurrentListNEW1_1Op";
        }
        return Packer.getCommonBizReqData(session, opName, packAll);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        BankResponse rsp = Parser.parseResponse(responseStr);
        String rspCode = rsp.getResponseCode();
        if (("C6666".equals(rspCode) || "10510206".equals(rspCode)) && Parser.canSearBalance(request)) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u54cd\u5e94\u7801'C6666',\u8ba4\u4e3a\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u53d1\u751f");
            EBBankDetailResponse response = new EBBankDetailResponse();
            response.setDetails((List)Lists.newArrayList());
            return response;
        }
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"0");
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String ACNO = ParserUtils.getUnNullElementTextValue((Element)opResult, (String)"ACNO", (String)ResManager.loadKDString((String)"\u8d26\u53f7", (String)"HistoryDetailImpl_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        BankAcnt acnt = request.getHeader().getAcnt();
        if (!ACNO.equals(acnt.getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7%1$s\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7%2$s\u4e0d\u4e00\u81f4", (String)"BalanceImpl_10", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), acnt.getAccNo(), ACNO));
        }
        Element opResultSet = opRep.getChild("opResultSet");
        List list = opResultSet.getChildren();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            String CDFG = ParserUtils.getUnNullElementTextValue((Element)element, (String)"CDFG", (String)ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u6807\u5fd7", (String)"HistoryDetailImpl_5", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            String FSJE = ParserUtils.getUnNullElementTextValue((Element)element, (String)"FSJE", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"HistoryDetailImpl_6", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            String JYRQ = element.getChildTextTrim("JYRQ");
            String PATI = element.getChildTextTrim("PATI");
            String FSSJ = element.getChildTextTrim("FSSJ");
            String DFZH = element.getChildTextTrim("DFZH");
            String DFHM = element.getChildTextTrim("DFHM");
            String YUER = element.getChildTextTrim("YUER");
            String YOTU = element.getChildTextTrim("YOTU");
            String BEZH = element.getChildTextTrim("BEZH");
            DetailInfo detail = new DetailInfo();
            detail.setAccName(acnt.getAccName());
            detail.setAccNo(acnt.getAccNo());
            detail.setOppAccName(DFHM);
            detail.setOppAccNo(DFZH);
            String DebitFlag = "1";
            String CreditFlag = "2";
            detail.setCurrency(request.getBankCurrency());
            BigDecimal amt = new BigDecimal(FSJE);
            if (DebitFlag.equals(CDFG)) {
                detail.setDebitAmount(amt);
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else if (CreditFlag.equals(CDFG)) {
                detail.setCreditAmount(amt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u501f\u8d37\u65b9\u6807\u5fd7\u503c\u5f02\u5e38(\u975e%1$s/%2$s):%3$s\u3002", (String)"HistoryDetailImpl_16", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), CreditFlag, DebitFlag, CDFG));
            }
            if (!StringUtils.isEmpty((String)YUER)) {
                detail.setBalance(new BigDecimal(YUER));
            }
            try {
                JYRQ = JYRQ.replaceAll(ResManager.loadKDString((String)"\u5e74", (String)"HistoryDetailImpl_8", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u6708", (String)"HistoryDetailImpl_9", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u65e5", (String)"HistoryDetailImpl_10", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), "");
                FSSJ = FSSJ.replaceAll(":", "").replaceAll(ResManager.loadKDString((String)"\u65f6", (String)"HistoryDetailImpl_11", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), "").replaceAll(ResManager.loadKDString((String)"\u5206", (String)"HistoryDetailImpl_12", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), "");
                FSSJ = (FSSJ + "000000").substring(0, 6);
                LocalDateTime transTime = LocalDateTime.parse(JYRQ + FSSJ, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransDate(transTime.toLocalDate());
                detail.setTransTime(transTime);
            }
            catch (Exception ex) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u4e2d\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u7684\u65e5\u671f\u4e0d\u5408\u6cd5\u3002", (String)"HistoryDetailImpl_13", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (Throwable)ex);
            }
            String bankDetailSeqId = null;
            if (!StringUtils.isEmpty((String)BEZH) && BEZH.indexOf("@KD") != -1) {
                bankDetailSeqId = BEZH.substring(0, BEZH.indexOf("@KD"));
                if (bankDetailSeqId.length() > 13) {
                    bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
            } else if (!StringUtils.isEmpty((String)YOTU) && YOTU.indexOf("@KD") != -1) {
                bankDetailSeqId = YOTU.substring(0, YOTU.indexOf("@KD"));
                if (bankDetailSeqId.length() > 13) {
                    bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 13);
                }
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
            }
            if (!StringUtils.isEmpty((String)YOTU)) {
                detail.setExplanation(YOTU);
            } else {
                detail.setExplanation(PATI);
            }
            detail.setCurrency("CNY");
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("JYRQ_P", (Object)JYRQ);
            jsonObject.put("rCDFG", (Object)(DebitFlag.equals(CDFG) ? "D" : "C"));
            detail.setJsonMap(jsonObject.toJSONString());
            detail.setBankDetailNo(element.getChildTextTrim("T24F"));
            String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonObject.toJSONString());
            detail.setReceiptNo(receiptNo);
            details.add(detail);
        }
        EBBankDetailResponse response = new EBBankDetailResponse();
        response.setDetails(details);
        return response;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }

    public boolean match(BankDetailRequest request) {
        return !BankBusinessConfig.isChooseNewDetail();
    }
}

