/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.newcrossbank;

import java.util.List;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "queryTransferResult2_1Op";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"OSNO", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        String packAll = Packer.packAllInOne(Sequence.gen16Sequence(), reqParam);
        packAll = JDomUtils.xml2XmlWithOutIndentLineSeparator((String)packAll, (String)CommumicationHelper.getEncoding4Comm());
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData(session, "queryTransferResult2_1Op", packAll);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)responseStr);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            return EBGBusinessUtils.buildQueryPayResponse((List)paymentInfos);
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String RECO = opResult.getChildTextTrim("RECO");
        String REMG = opResult.getChildTextTrim("REMG");
        if ("0000".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)RECO, (String)REMG);
        } else if ("0001".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)RECO, (String)REMG);
        } else if ("0004".equals(RECO) || "0005".equals(RECO) || "0006".equals(RECO)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)RECO, (String)REMG);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)RECO, (String)REMG);
        }
        return EBGBusinessUtils.buildQueryPayResponse((List)paymentInfos);
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

