/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    private static final DateTimeFormatter dateTimePattern = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String KD = "@KD";

    public static String packAllInOne(String serialNo, Element reqParam) {
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(dateTimePattern));
        JDomUtils.addChild((Element)opReq, (Element)reqParam);
        Element root = new Element("BOSEBankData");
        JDomUtils.addChild((Element)root, (Element)opReq);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)CommumicationHelper.getEncoding4Comm());
    }

    public static String getCommonBizReqData(String dse_sessionId, String opName, String reqData) {
        StringBuilder localStringBuilder = new StringBuilder();
        localStringBuilder.append("dse_sessionId").append("=").append(dse_sessionId).append("&").append("opName").append("=").append(opName).append("&").append("reqData").append("=").append(reqData);
        return localStringBuilder.toString();
    }

    public static String addKd(PaymentInfo paymentInfo) {
        String all = paymentInfo.getBankDetailSeqId() + KD + paymentInfo.getExplanation();
        if (all.length() > 40) {
            all = all.substring(0, 40);
        }
        return all;
    }
}

