/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.RequestPacker;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.ResponseParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element head = RequestPacker.getHeadPackerData("200110", "0", Sequence.genSequence());
        Element body = RequestPacker.getDetailRequestBody(bankDetailRequest);
        String requestStr = RequestPacker.getRequest(head, body);
        return requestStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        return this.parseTodayDetail(res);
    }

    public EBBankDetailResponse parseTodayDetail(String response) {
        Element element = CommonUtil.getResponseElement(response);
        CommonUtil.resSuccessCheck(element);
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        try {
            Element body = element.getChild("body");
            Element head = element.getChild("head");
            String recordNumStr = body.getChildTextTrim("record_num");
            String fieldNumStr = body.getChildTextTrim("field_num");
            String fileFlag = head.getChildTextTrim("file_flag");
            if (StringUtils.isEmpty((String)fieldNumStr) || StringUtils.isEmpty((String)recordNumStr)) {
                logger.info("====\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6===");
                return new EBBankDetailResponse(details);
            }
            int fieldNum = Integer.parseInt(fieldNumStr);
            int recordNum = Integer.parseInt(recordNumStr);
            if (fieldNum <= 0 || recordNum <= 0) {
                logger.info("===\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6===");
                return new EBBankDetailResponse(details);
            }
            String content = ResponseParser.resContentHandle(body, fileFlag);
            String[][] rs = ResponseParser.parseContent(content, recordNum, fieldNum);
            for (int k = 0; k < rs.length; ++k) {
                DetailInfo detailInfo;
                String[] detailArray = rs[k];
                try {
                    detailInfo = this.parseRecord(detailArray);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    continue;
                }
                details.add(detailInfo);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    private DetailInfo parseRecord(String[] detailArray) {
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(detailArray[1]);
        detailInfo.setAccName(detailArray[7]);
        detailInfo.setOppAccNo(detailArray[8]);
        detailInfo.setOppAccName(detailArray[10]);
        detailInfo.setBankName(detailArray[11]);
        detailInfo.setCurrency(detailArray[2]);
        String tranDate = detailArray[3];
        String tranTime = detailArray[4];
        if (!StringUtils.isEmpty((String)tranDate)) {
            detailInfo.setTransDate(LocalDateUtil.parserDate((String)tranDate));
            if (!StringUtils.isEmpty((String)tranTime)) {
                tranDate = tranDate + tranTime;
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)tranDate));
            } else {
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(tranDate + "000000")));
            }
        } else {
            logger.info("====\u8fd4\u56de\u7684tr_acdt\u4e3a\u7a7a====");
        }
        String tranFlag = detailArray[23];
        String amt = detailArray[24];
        if ("D".equalsIgnoreCase(tranFlag)) {
            detailInfo.setDebitAmount(new BigDecimal(amt));
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
        } else if ("C".equalsIgnoreCase(tranFlag)) {
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
            detailInfo.setCreditAmount(new BigDecimal(amt));
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)tranFlag));
        }
        String postscript = detailArray[35];
        String summary = detailArray[34];
        if (!StringUtils.isEmpty((String)postscript)) {
            detailInfo.setExplanation(postscript);
        } else {
            detailInfo.setExplanation(summary);
        }
        if (postscript != null && postscript.indexOf("@KD") >= 0) {
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)postscript.substring(0, postscript.indexOf("@KD")));
        }
        String balance = detailArray[25];
        detailInfo.setBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)true));
        JSONObject receiptJson = new JSONObject();
        receiptJson.put("serial_no", (Object)detailArray[0]);
        receiptJson.put("acno", (Object)detailArray[1]);
        receiptJson.put("cur_code", (Object)detailArray[2]);
        receiptJson.put("tr_acdt", (Object)detailArray[3]);
        receiptJson.put("platform_serial_no", (Object)detailArray[detailArray.length - 1]);
        receiptJson.put("postscript", (Object)postscript);
        receiptJson.put("purpose", (Object)summary);
        detailInfo.setJsonMap(receiptJson.toJSONString());
        return detailInfo;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]);
    }
}

