/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.hk.service.payment.fps;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.hk.service.Packer;
import kd.ebg.aqap.banks.gdb.hk.service.Parser;
import kd.ebg.aqap.banks.gdb.hk.service.payment.fps.QueryFPSImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FPSPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryFPSImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "2063", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)message, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"REMITTYPE", (String)"01");
        JDomUtils.addChild((Element)body, (String)"PAYACC", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"REMITCUR", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"REMITAMOUNT", (String)paymentInfo.getActualAmount().setScale(2, 1).toString());
        String type = "BBAN";
        JDomUtils.addChild((Element)body, (String)"PAYEEACTYPE", (String)type);
        String acct = paymentInfo.getIncomeAccNo();
        JDomUtils.addChild((Element)body, (String)"BENEFCORPACCT", (String)acct);
        JDomUtils.addChild((Element)body, (String)"PAYEEBANK", (String)"359");
        JDomUtils.addChild((Element)body, (String)"BENEFCORPNAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"PAYEEIDTYPE", (String)"");
        JDomUtils.addChild((Element)body, (String)"PAYPURS", (String)"CXBSNS");
        JDomUtils.addChild((Element)body, (String)"REMITMEMO", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"MEMO", (String)paymentInfo.getExplanation());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "2063";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"FPS\u4ea4\u6613", (String)"FPSPaymentImpl_0", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/CGBClient_mo/BankAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

