/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.hk.service.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.hk.service.Packer;
import kd.ebg.aqap.banks.gdb.hk.service.Parser;
import kd.ebg.aqap.banks.gdb.hk.service.payment.oversea.QueryOVRSImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OVRSPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryOVRSImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0012", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)message, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"PAYACC", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAYCURRTYPE", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)body, (String)"REMITCUR", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)body, (String)"REMITAMOUNT", (String)paymentInfo.getActualAmount().setScale(2, 1).toString());
        JDomUtils.addChild((Element)body, (String)"BENEFCORPACCT", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"BENEFCORPNAME", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"BENEFCORPADD", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)body, (String)"ISGFBANK", (String)(paymentInfo.is2SameBank() ? "Y" : "N"));
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"RECVBANKNAME", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)body, (String)"RECVBANKADD", (String)paymentInfo.getIncomeBankAddress());
        } else {
            JDomUtils.addChild((Element)body, (String)"SKHSWIFTCODE", (String)paymentInfo.getIncomeSwiftCode());
            JDomUtils.addChild((Element)body, (String)"AGENCYBANKSWIFT", (String)paymentInfo.getProxyBankSwiftCode());
            JDomUtils.addChild((Element)body, (String)"AGENCYBANKNAME", (String)paymentInfo.getProxyBankName());
        }
        if (paymentInfo.getPayerFeeType().equals("01")) {
            JDomUtils.addChild((Element)body, (String)"CHAREGEASSUME", (String)"OUR");
        } else if (paymentInfo.getPayerFeeType().equals("02")) {
            JDomUtils.addChild((Element)body, (String)"CHAREGEASSUME", (String)"BEN");
        } else if (paymentInfo.getPayerFeeType().equals("03")) {
            JDomUtils.addChild((Element)body, (String)"CHAREGEASSUME", (String)"SHA");
        } else {
            JDomUtils.addChild((Element)body, (String)"CHAREGEASSUME", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"FXCUR", (String)paymentInfo.getProxyFeeCurrency());
        JDomUtils.addChild((Element)body, (String)"PURCHASECUR", (String)paymentInfo.getProxyAccNo());
        JDomUtils.addChild((Element)body, (String)"CHAREGECUR", (String)paymentInfo.getPayerFeeCurrency());
        JDomUtils.addChild((Element)body, (String)"CHARGEACCT", (String)paymentInfo.getPayerFeeAccNo());
        JDomUtils.addChild((Element)body, (String)"REMITMEMO", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"MEMO", (String)"");
        String payProperty = paymentInfo.getPayProperty();
        String payType = "0".equalsIgnoreCase(payProperty) ? "A" : ("1".equalsIgnoreCase(payProperty) ? "P" : ("2".equalsIgnoreCase(payProperty) ? "R" : "3"));
        JDomUtils.addChild((Element)body, (String)"PAYTYPE", (String)payType);
        JDomUtils.addChild((Element)body, (String)"PAYMENTPROPERTY", (String)"F");
        JDomUtils.addChild((Element)body, (String)"APPRSIGN", (String)"0");
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        JDomUtils.addChild((Element)body, (String)"STATE", (String)code.getNumberCode());
        JDomUtils.addChild((Element)body, (String)"Part_city", (String)paymentInfo.getIncomeProvince());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"OVERSEA\u4ea4\u6613", (String)"OVRSPaymentImpl_0", (String)"ebg-aqap-banks-gdb-hk", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/CGBClient_mo/BankAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

