/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cbhb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cbhb.dc.services.Packer;
import kd.ebg.aqap.banks.cbhb.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankBalanceRequest request) {
        String seqNo = Sequence.genSequence();
        Element root = JDomUtils.createRoot((String)"CBHB");
        Element head = Packer.ccreateCommonHead("QRACBL", seqNo);
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"Ccy", (String)request.getBankCurrency());
        String xmlStr = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return xmlStr;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader(root);
        if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{response.getResponseCode(), response.getResponseMessage()})));
        }
        Element body = root.getChild("body");
        String acntNo = body.getChildTextTrim("AcctNo");
        String bal = body.getChildTextTrim("Bal");
        String availBal = body.getChildTextTrim("AvailBal");
        String ccy = body.getChildTextTrim("Ccy");
        if (!acnt.getAccNo().equalsIgnoreCase(acntNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u9519\u8bef :\u8fd4\u56de\u7684\u8d26\u53f7%1$s\u4e0d\u662f\u67e5\u8be2\u8d26\u53f7%2$s\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]), acntNo, acnt.getAccNo()));
        }
        BalanceInfo[] balances = new BalanceInfo[]{new BalanceInfo()};
        balances[0].setBankAcnt(acnt);
        if (StringUtils.isEmpty((String)bal)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-cbhb-dc", (Object[])new Object[0]));
        }
        balances[0].setCurrentBalance(new BigDecimal(bal));
        LocalDateTime localDateTime = LocalDateTime.now();
        balances[0].setBalanceDateTime(localDateTime);
        balances[0].setBankCurrency(ccy);
        if (!StringUtils.isEmpty((String)availBal)) {
            balances[0].setAvailableBalance(new BigDecimal(availBal));
        }
        ArrayList<BalanceInfo> balancesList = new ArrayList<BalanceInfo>(16);
        balancesList.add(balances[0]);
        return new EBBankBalanceResponse(balancesList);
    }
}

