/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbsg.h2h.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.JDom11Utils;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SCBSG_H2H_PAY_ACK_Handler
extends AbstractACKHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SCBSG_H2H_PAY_ACK_Handler.class);

    protected List<PaymentInfo> processFile(File file) {
        String name = file.getName();
        List<Object> list = Lists.newArrayList();
        try {
            if (this.isFileLevelACK(name)) {
                list = this.processFileLevelACK(file);
            } else if (this.isTransactionLevelACK(name)) {
                list = this.processTransactionLevelACK(file);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a[%1$s]\u51fa\u9519\u3002", (String)"SCBSG_H2H_PAY_ACK_Handler_4", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), file.getName()), (Throwable)e);
        }
        return list;
    }

    private List<PaymentInfo> processTransactionLevelACK(File file) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String bankBatchSeqId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List pmtList = cstrpt.getChildren("OrgnlPmtInfAndSts", ns);
        HashMap<String, PayGen> map = new HashMap<String, PayGen>(16);
        for (Element ele : pmtList) {
            Element TxInfAndSts = JDom11Utils.getChildElement((Element)ele, (String)"TxInfAndSts", (Namespace)ns);
            String bankDetailSeqId = TxInfAndSts.getChildText("OrgnlEndToEndId", ns);
            String TxSts = TxInfAndSts.getChildText("TxSts", ns);
            Element StsRsnInf = TxInfAndSts.getChild("StsRsnInf", ns);
            String txMsg = TxSts;
            if (StsRsnInf != null) {
                txMsg = StsRsnInf.getChildText("AddtlInf", ns);
            }
            PayGen payGen = new PayGen();
            payGen.setErrorCode(TxSts);
            payGen.setErrorMsg(txMsg);
            map.put(bankDetailSeqId, payGen);
        }
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)bankBatchSeqId);
        if (CollectionUtil.isNotEmpty((Collection)payInfoList)) {
            this.logger.info(String.format("\u6839\u636e\u6279\u6b21\u53f7%s\u627e\u5230%s\u7b14\u4ed8\u6b3e\u8bb0\u5f55\u5f85\u66f4\u65b0", bankBatchSeqId, payInfoList.size()));
        }
        for (PaymentInfo paymentInfo : payInfoList) {
            PayGen payGen = (PayGen)map.get(paymentInfo.getBankDetailSeqID());
            if (payGen == null) continue;
            String status = payGen.getErrorCode();
            String txMsg = payGen.getErrorMsg();
            if ("RJCT".equalsIgnoreCase(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SCBSG_H2H_PAY_ACK_Handler_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)status, (String)txMsg);
                continue;
            }
            if ("ACSP".equalsIgnoreCase(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SCBSG_H2H_PAY_ACK_Handler_1", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)status, (String)txMsg);
                continue;
            }
            if ("ACCP".equalsIgnoreCase(status) || "PDNG".equalsIgnoreCase(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SCBSG_H2H_PAY_ACK_Handler_2", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)status, (String)txMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SCBSG_H2H_PAY_ACK_Handler_3", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)status, (String)txMsg);
        }
        return payInfoList;
    }

    private List<PaymentInfo> processFileLevelACK(File file) throws Exception {
        this.logger.info(String.format("ack file: %s content:\r\n %s", file.getName(), FileUtils.readFileToString((File)file, (String)"UTF-8")));
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        String GrpSts = orgnlgst.getChildText("GrpSts", ns);
        Element StsRsnInf = orgnlgst.getChild("StsRsnInf", ns);
        String txMsg = GrpSts;
        if (StsRsnInf != null) {
            txMsg = StsRsnInf.getChildText("AddtlInf", ns);
        }
        if (CollectionUtil.isNotEmpty((Collection)payInfoList)) {
            this.logger.info(String.format("\u6839\u636e\u6279\u6b21\u53f7%s\u627e\u5230%s\u7b14\u4ed8\u6b3e\u8bb0\u5f55\u5f85\u66f4\u65b0", batchId, payInfoList.size()));
            if (GrpSts.startsWith("AC") && GrpSts.length() == 4) {
                EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)payInfoList, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SCBSG_H2H_PAY_ACK_Handler_2", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            } else if (GrpSts.equalsIgnoreCase("RJCT")) {
                EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)payInfoList, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SCBSG_H2H_PAY_ACK_Handler_0", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            } else {
                EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)payInfoList, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SCBSG_H2H_PAY_ACK_Handler_3", (String)"ebg-aqap-banks-scbsg-h2h", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            }
        }
        return payInfoList;
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return this.isFileLevelACK(fileName) || this.isTransactionLevelACK(fileName);
    }

    private boolean isFileLevelACK(String fileName) {
        return fileName.contains("ACK") || fileName.contains("REJ");
    }

    private boolean isTransactionLevelACK(String fileName) {
        return fileName.contains("BANSTA");
    }

    private static class PayGen {
        private String errorCode;
        private String errorMsg;

        private PayGen() {
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}

