/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.async;

import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.async.BankTask;
import kd.ebg.aqap.common.framework.async.BankTaskResult;
import kd.ebg.aqap.common.framework.async.DefaultBankTaskExecutor;
import kd.ebg.aqap.common.framework.async.IProcess;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.bank.info.EBBankResponse;
import kd.ebg.egf.common.log.EBGLogger;

public class BankTaskWorker
implements Callable<BankTaskResult> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankTaskWorker.class);
    private IProcess process;
    private BankTask task;

    public BankTaskWorker(IProcess process, BankTask task) {
        this.process = process;
        this.task = task;
        if (process == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"process\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankTaskWorker_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (task == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"task\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankTaskWorker_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BankTaskResult call() {
        BankTaskResult result = new BankTaskResult();
        try {
            BankRequest request = this.task.getRequest();
            request.getHeader().setLogBizSeqID(this.task.getBizSeqID());
            EBContext context = this.task.getContext();
            Map<String, Object> params = this.task.getParams();
            if (request == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"request\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankTaskWorker_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            if (context == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"context\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankTaskWorker_3", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            BankHeader header = request.getHeader();
            if (header == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"header\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BankTaskWorker_4", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            String bankVersionID = header.getBankVersionID();
            String bankLoginID = header.getBankLoginID();
            EBContext.setContext((EBContext)context);
            logger.info("\u5f00\u59cb\u6267\u884c \u94f6\u884c\u5f02\u6b65\u4efb\u52a1 bankVersionID:{} , bankLoginID:{}", new Object[]{bankVersionID, bankLoginID});
            Object response = this.process.execute(request, context, params);
            result.setResponse((EBBankResponse)(null == response ? new EBBankResponse() : response));
            result.setContext(context);
            result.setParams(this.task.getParams());
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        finally {
            SpringContextUtil.getBean(DefaultBankTaskExecutor.class).removeTaskId(this.task.getId());
            EBContext.destroy();
        }
        return result;
    }
}

