/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.async.utils;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.async.IProcess;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankRequest;

@Component
public class ProcessFactory {
    private final List<IProcess> processList;
    private final Map<Class<?>, List<IProcess>> processMap;

    public ProcessFactory(List<IProcess> processes) {
        this.processList = processes;
        HashMap map = new HashMap(16);
        for (IProcess process : processes) {
            Class<?> requestClass = this.getRequestClass(process);
            if (!map.containsKey(requestClass)) {
                map.put(requestClass, new ArrayList(1));
            }
            List processList = (List)map.get(requestClass);
            processList.add(process);
        }
        this.processMap = Collections.unmodifiableMap(map);
    }

    public static ProcessFactory getInstance() {
        return SpringContextUtil.getBean(ProcessFactory.class);
    }

    private Class<?> getRequestClass(IProcess process) {
        return (Class)((ParameterizedType)process.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    public IProcess getProcess(BankRequest request) {
        if (Objects.isNull(request)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"ProcessFactory_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (!this.processMap.containsKey(request.getClass())) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5904\u7406\uff1a%s \u7684\u5904\u7406\u5668\u3002", (String)"ProcessFactory_5", (String)"ebg-aqap-common", (Object[])new Object[0]), request.getClass().getName()));
        }
        IProcess result = null;
        for (IProcess process : this.processMap.get(request.getClass())) {
            if (!process.match(request)) continue;
            result = process;
            break;
        }
        if (Objects.isNull(result)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"request \u53c2\u6570\u7c7b\u578b:%s \u6ca1\u6709\u627e\u5230\u5408\u9002\u7684 process\u3002", (String)"ProcessFactory_6", (String)"ebg-aqap-common", (Object[])new Object[0]), request.getClass().getName()));
        }
        return result;
    }
}

