/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.model.repository.OpenCreditRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

@Service
public class OpenCreditService {
    EBGLogger logger = EBGLogger.getInstance().getLogger(OpenCreditService.class);
    private String PAYMENTINFO_ENTITY = "aqap_bd_paymentinfo";
    @Autowired
    private OpenCreditRepository openCreditRepository;

    public static OpenCreditService getInstance() {
        return SpringContextUtil.getBean(OpenCreditService.class);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.openCreditRepository.countByBatchSeqId(batchSeqID) > 0L;
    }

    public boolean detailBizExist(String batchSeqID) {
        return this.openCreditRepository.countDetailBizId(batchSeqID) > 0L;
    }

    public List<OpenCreditDetail> selectByBatchSeqID(String batchSeqID) {
        return this.openCreditRepository.findByBatchSeqId(batchSeqID);
    }

    public List<OpenCreditDetail> save(List<OpenCreditDetail> openCreditDetails, boolean insertAction) {
        if (openCreditDetails.size() == 0) {
            return openCreditDetails;
        }
        openCreditDetails.forEach(paymentInfo -> {
            if (insertAction) {
                paymentInfo.setInsertTime(LocalDateTime.now());
            }
            paymentInfo.setUpdateTime(LocalDateTime.now());
        });
        TXHandle h = TX.requiresNew();
        try {
            List<OpenCreditDetail> list = openCreditDetails = this.openCreditRepository.save(openCreditDetails);
            return list;
        }
        catch (Exception e) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f00\u8bc1\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38", (String)"OpenCreditService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<OpenCreditDetail> compareAndStateState(List<OpenCreditDetail> openCreditDetails, PaymentState expectedState, PaymentState state) {
        for (OpenCreditDetail info : openCreditDetails) {
            if (info.getStatus().intValue() != expectedState.getId()) {
                this.logger.info("\u4ed8\u6b3e :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expectedState.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
            info.setSubmitSuccessTime(LocalDateTime.now());
        }
        try {
            return this.save(openCreditDetails, false);
        }
        catch (Throwable var6) {
            String bankBatchSeqID = openCreditDetails.get(0).getBankBatchSeqId();
            this.logger.error("\u94f6\u884c\u6279\u6b21\u53f7\u4e3a:{}", new Object[]{bankBatchSeqID});
            this.logger.error("\u5c1d\u8bd5\u4fee\u6539\u72b6\u6001\u5931\u8d25" + var6.getMessage(), var6);
            return null;
        }
    }
}

