/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.balance.Balance;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequest;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequestBody;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponse;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponseBody;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.model.repository.AlertMessageRepository;
import kd.ebg.aqap.common.model.repository.BankLoginLinkCheckRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.monitor.LoginLinkCheckInfo;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BLoginLinkCheckTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BLoginLinkCheckTask.class);
    private final String signature = ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91", (String)"BLoginLinkCheckTask_0", (String)"ebg-aqap-common", (Object[])new Object[0]);
    private final String STATUS_NORMAL = "normal";
    private final String STATUS_EXCEPTION = "exception";
    private final String TYPE_ACTIVE = "active";
    private final String TYPE_PASSIVE = "passive";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        BankLoginLinkCheckRepository repository;
        block17: {
            MDC.put((String)"schedule", (String)"true");
            MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
            this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u68c0\u67e5\u5f00\u542f");
            String customID = requestContext.getTenantId();
            BankReqRecordRepository bankReqRecordRepository = SpringContextUtil.getBean(BankReqRecordRepository.class);
            repository = SpringContextUtil.getBean(BankLoginLinkCheckRepository.class);
            AlertMessageRepository alertMessageRepository = SpringContextUtil.getBean(AlertMessageRepository.class);
            try {
                BankLoginRepository bankLoginRepository = SpringContextUtil.getBean(BankLoginRepository.class);
                List bankLoginList = bankLoginRepository.findAllByCustomerID(customID);
                LocalDateTime now = LocalDateTime.now();
                int interval = this.getMonitorRate();
                LocalDateTime start = this.getStartTime(now, interval);
                LocalDateTime end = this.getEndTime(now, interval);
                if (bankLoginList == null) break block17;
                String type = "active";
                String status = "normal";
                String message = "";
                boolean isAlert = false;
                boolean isInsert = false;
                for (BankLogin bankLogin : bankLoginList) {
                    block18: {
                        block20: {
                            if ("0".equals(bankLogin.getEnable())) {
                                this.logger.info("\u524d\u7f6e\u673a{}\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u505a\u8fde\u63a5\u68c0\u67e5", (Object)bankLogin.getKey().getBankLoginId());
                                continue;
                            }
                            if (repository.isHasChecked(customID, bankLogin.getKey().getBankLoginId(), start, end)) break block20;
                            this.logger.info("\u524d\u7f6e\u673a{}\u6700\u8fd1\u4e00\u6bb5\u65f6\u95f4\u6ca1\u6709\u4e1a\u52a1\u8bf7\u6c42\u9a8c\u8bc1\u8fde\u63a5", (Object)bankLogin.getKey().getBankLoginId());
                            isInsert = true;
                            if (bankReqRecordRepository.isHasRecords(customID, bankLogin.getKey().getBankLoginId(), start, end)) {
                                this.logger.info("\u524d\u7f6e\u673a{}\u4ece\u4e1a\u52a1\u8bf7\u6c42\u6821\u9a8c\u8fde\u901a", (Object)bankLogin.getKey().getBankLoginId());
                                String errorMsg = bankReqRecordRepository.getErrorRecords(customID, bankLogin.getKey().getBankLoginId(), start, end);
                                boolean isError = StringUtils.isNotEmpty((String)errorMsg);
                                type = "passive";
                                status = isError ? "exception" : "normal";
                                message = isError ? String.format(ResManager.loadKDString((String)"\u5386\u53f2\u4e1a\u52a1\u8bf7\u6c42\u5b58\u5728\u5f02\u5e38\uff0c%s\u3002", (String)"BLoginLinkCheckTask_4", (String)"ebg-aqap-common", (Object[])new Object[0]), errorMsg) : "";
                                isAlert = "exception".equals(status);
                                break block18;
                            } else {
                                this.logger.info("\u524d\u7f6e\u673a{}\u5f00\u542f\u4f59\u989d\u67e5\u8be2\u9a8c\u8bc1\u8fde\u63a5", (Object)bankLogin.getKey().getBankLoginId());
                                String accNo = this.getQueryAccNO(bankLogin.getKey().getBankLoginId());
                                if (StringUtils.isNotEmpty((String)accNo)) {
                                    if (!BLoginLinkCheckTask.checkAcntEnable(accNo, bankLogin.getKey().getCustomId())) {
                                        this.logger.info("\u8d26\u53f7{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8df3\u8fc7\u524d\u7f6e\u673a{}\u7684\u8fde\u63a5\u68c0\u67e5", new Object[]{accNo, bankLogin.getKey().getBankLoginId()});
                                        continue;
                                    }
                                    String bankVersionID = bankLogin.getBankVersionId();
                                    String bankLoginID = bankLogin.getKey().getBankLoginId();
                                    String bizSeqID = Sequence.gen18Sequence();
                                    EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customID).requestSeqID("").bizName("batchBalance").subBizName("batchBalance").bankVersionID(bankVersionID).bankLoginID(bankLoginID).bizSeqID(bizSeqID).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(String.valueOf(System.currentTimeMillis())).loggerBankNo(bizSeqID).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).schedule(true).build();
                                    EBContext.setContext((EBContext)context);
                                    MDCUtil.clearBussinessMDC();
                                    MDCUtil.initMDC((EBContext)context);
                                    this.logger.infoIndex("");
                                    this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u76d1\u63a7\u4e3b\u52a8\u68c0\u6d4b");
                                    MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                                    message = this.balanceTest(customID, accNo);
                                    status = StringUtils.isEmpty((String)message) ? "normal" : "exception";
                                    type = "active";
                                    isAlert = "exception".equals(status);
                                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                    this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u76d1\u63a7\u4e3b\u52a8\u68c0\u6d4b\u7ed3\u675f\uff0cstatus={}", (Object)status);
                                    MDCUtil.clearBussinessMDC();
                                    EBContext.destroy();
                                    break block18;
                                } else {
                                    this.logger.info("\u524d\u7f6e\u673a{}\u8d26\u53f7\u4e3a\u7a7a\uff0c\u8fde\u63a5\u68c0\u67e5\u7ed3\u675f", (Object)bankLogin.getKey().getBankLoginId());
                                    continue;
                                }
                            }
                        }
                        this.logger.info("\u524d\u7f6e\u673a{}\u8fde\u63a5\u9884\u8b66\u8865\u507f\u6821\u9a8c", (Object)bankLogin.getKey().getBankLoginId());
                        List<LoginLinkCheckInfo> loginLinkCheckInfos = repository.findByCustomIDAndLoginAndSearchTime(customID, bankLogin.getKey().getBankLoginId(), start, end);
                        for (LoginLinkCheckInfo info : loginLinkCheckInfos) {
                            if (info.getNotifyTime() != null || !info.getStatus().equals("exception")) continue;
                            isAlert = true;
                            break;
                        }
                    }
                    if (isAlert &= !repository.isHasAlertIn30Min(customID, bankLogin.getKey().getBankLoginId())) {
                        this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u9884\u8b66\u6d88\u606f\u51c6\u5907\u53d1\u9001");
                        String phone = this.getUserPhone();
                        if (StringUtils.isNotEmpty((String)phone)) {
                            if (!this.isNoticeMaxNum(bankLogin.getKey().getBankLoginId())) {
                                KDSMSSender sender = new KDSMSSender();
                                String msg = this.getAlertMsg(bankLogin);
                                boolean result = sender.sendMessage(phone, msg, this.signature);
                                this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u9884\u8b66\u6d88\u606f\u53d1\u9001\u5b8c\u6210");
                                alertMessageRepository.save("2", CosmicConstants.ALERT_TYPE_MOBILE, phone, new Date(), "\u3010" + this.signature + "\u3011" + msg, String.valueOf(result));
                            } else {
                                isAlert = false;
                                this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u9884\u8b66\u6d88\u606f\u53d1\u9001\u8fbe\u5230\u6700\u5927\u6b21\u6570");
                            }
                        } else {
                            isAlert = false;
                            this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u9884\u8b66\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
                        }
                    }
                    if (!isInsert) continue;
                    LoginLinkCheckInfo info = new LoginLinkCheckInfo();
                    info.setUpdateTime(now);
                    if (isAlert) {
                        info.setNotifyTime(now);
                    } else {
                        info.setNotifyTime(now.minusYears(100L));
                    }
                    info.setCustomID(customID);
                    info.setBankVersionID(bankLogin.getBankVersionId());
                    info.setBankLoginID(bankLogin.getKey().getBankLoginId());
                    info.setType(type);
                    info.setStatus(status);
                    info.setMessage(message);
                    repository.save(info);
                }
            }
            catch (Exception e) {
                this.logger.error("\u524d\u7f6e\u673a\u8fde\u63a5\u68c0\u67e5\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        this.logger.info("\u524d\u7f6e\u673a\u8fde\u63a5\u68c0\u67e5\u5b8c\u6210");
        repository.deleteHistory(this.getHistoryDays());
    }

    public String balanceTest(String customerID, String accNo) {
        try {
            BatchBalanceResponse response = this.todayBalance(customerID, accNo);
            Balance balance = response.getBody().getBalances().get(0);
            if (StringUtils.isEmpty((String)balance.getError())) {
                return "";
            }
            return balance.getError();
        }
        catch (Exception ex) {
            this.logger.error("\u524d\u7f6e\u673a\u8fde\u63a5\u6d4b\u8bd5\u68c0\u67e5\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)ex);
            return String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u8fde\u63a5\u6d4b\u8bd5\u68c0\u67e5\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff1a%s\u3002", (String)"BLoginLinkCheckTask_5", (String)"ebg-aqap-common", (Object[])new Object[0]), ex.getMessage());
        }
    }

    public BatchBalanceResponse todayBalance(String customerID, String accNo) {
        BankAcntRepository bankAcntRepository = SpringContextUtil.getBean(BankAcntRepository.class);
        BankAcnt bankAcnt = bankAcntRepository.findByAccNoAndCustomID(accNo, customerID);
        BatchBalanceRequest balanceRequest = new BatchBalanceRequest();
        EBHeader header = new EBHeader();
        header.setAccNo(accNo);
        header.setBizType("batchBalance");
        header.setSubBizType("today_balance");
        header.setClientName("JDY");
        header.setClientVersion("1.0");
        header.setCustomId(customerID);
        header.setBizSeqID(EBContext.getContext().getBizSeqID());
        String currency = bankAcnt.getCurrency();
        if (StringUtils.isEmpty((String)currency)) {
            currency = "CNY";
        }
        header.setCurrency(currency);
        header.setRequestTime(System.currentTimeMillis());
        BatchBalanceRequestBody body = new BatchBalanceRequestBody();
        balanceRequest.setHeader(header);
        balanceRequest.setBody(body);
        body.setStartDate(LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setEndDate(LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.setAccNos(Lists.newArrayList((Object[])new String[]{accNo}));
        try {
            BatchBalanceResponse balanceResponse = (BatchBalanceResponse)((Object)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"balance", (String)"balance", (Object[])new Object[]{balanceRequest}));
            if (Objects.nonNull((Object)balanceResponse) && Objects.nonNull(balanceResponse.getException())) {
                boolean isConnectError = balanceResponse.getException().isConnectionException();
                if (isConnectError) {
                    throw new EBServiceException(balanceResponse.getException().getMessage());
                }
                ArrayList<Balance> balanceList = new ArrayList<Balance>(1);
                Balance balance = new Balance();
                balance.setError("");
                balanceList.add(balance);
                BatchBalanceResponseBody responseBody = new BatchBalanceResponseBody();
                responseBody.setBalances(balanceList);
                balanceResponse.setBody(responseBody);
                return balanceResponse;
            }
            return balanceResponse;
        }
        catch (JSONException e) {
            throw new EBServiceException((Throwable)e);
        }
    }

    private LocalDateTime getStartTime(LocalDateTime now, int interval) {
        int year = now.getYear();
        int month = now.getMonthValue();
        int dayOfMonth = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        minute = Math.floorDiv(minute, interval) * interval;
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, 0);
    }

    private LocalDateTime getEndTime(LocalDateTime now, int interval) {
        int year = now.getYear();
        int month = now.getMonthValue();
        int dayOfMonth = now.getDayOfMonth();
        int hour = now.getHour();
        int minute = now.getMinute();
        if ((minute = (Math.floorDiv(minute, interval) + 1) * interval) >= 60) {
            hour += minute / 60;
            minute %= 60;
        }
        return LocalDateTime.of(year, month, dayOfMonth, hour, minute, 0);
    }

    private String getUserPhone() {
        ObjectPropertiesRepository propertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);
        String phone = "";
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID("common_business");
        key.setObjectName("monitor_setting");
        key.setAttrKey("phone_number");
        ObjectProperties objectProperties = propertiesRepository.findById(key);
        if (objectProperties != null) {
            phone = objectProperties.getAttrValue();
        }
        return phone;
    }

    private String getAlertMsg(BankLogin bankLogin) {
        String bankVersionName = bankLogin.getBankVersionName();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        String bankLoginID = bankLogin.getKey().getBankLoginId();
        return String.format(ResManager.loadKDString((String)"\u5728%1$s\u76d1\u6d4b\u5230\uff0c%2$s\uff0c\u524d\u7f6e\u673a\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a%3$s\u3002", (String)"BLoginLinkCheckTask_3", (String)"ebg-aqap-common", (Object[])new Object[0]), time, bankVersionName, bankLoginID);
    }

    private int getMonitorRate() {
        ObjectPropertiesRepository propertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);
        int rate = 10;
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID("common_business");
        key.setObjectName("monitor_setting");
        key.setAttrKey("monitor_rate");
        ObjectProperties objectProperties = propertiesRepository.findById(key);
        if (objectProperties != null) {
            try {
                rate = Integer.parseInt(objectProperties.getAttrValue());
            }
            catch (NumberFormatException e) {
                this.logger.error("\u83b7\u53d6\u524d\u7f6e\u673a\u8fde\u63a5\u76d1\u63a7\u5468\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff0c\u542f\u7528\u9ed8\u8ba4\u503c10min");
            }
        }
        return rate;
    }

    private int getHistoryDays() {
        ObjectPropertiesRepository propertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);
        int days = 7;
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID("common_business");
        key.setObjectName("monitor_setting");
        key.setAttrKey("history_time");
        ObjectProperties objectProperties = propertiesRepository.findById(key);
        if (objectProperties != null) {
            try {
                days = Integer.parseInt(objectProperties.getAttrValue());
            }
            catch (NumberFormatException e) {
                this.logger.error("\u83b7\u53d6\u524d\u7f6e\u673a\u8fde\u63a5\u5386\u53f2\u6570\u636e\u4fdd\u5b58\u5929\u6570\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff0c\u542f\u7528\u9ed8\u8ba4\u503c7\u5929");
            }
        }
        return days;
    }

    private String getQueryAccNO(String bankLoginID) {
        ObjectPropertiesRepository propertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);
        String accNo = "";
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID(bankLoginID);
        key.setObjectName("monitor_link");
        key.setAttrKey("query_account");
        ObjectProperties objectProperties = propertiesRepository.findById(key);
        if (objectProperties != null) {
            accNo = objectProperties.getAttrValue();
        }
        return accNo;
    }

    private int getNoticeMaxNum() {
        ObjectPropertiesRepository propertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);
        int maxNum = 0;
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setCustomID(RequestContext.get().getTenantId());
        key.setObjectID("common_business");
        key.setObjectName("monitor_setting");
        key.setAttrKey("notice_rate");
        ObjectProperties objectProperties = propertiesRepository.findById(key);
        if (objectProperties != null) {
            try {
                maxNum = Integer.parseInt(objectProperties.getAttrValue());
            }
            catch (NumberFormatException e) {
                this.logger.error("\u83b7\u53d6\u77ed\u4fe1\u6700\u5927\u6b21\u6570\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff0c\u542f\u7528\u9ed8\u8ba4\u503c10min");
            }
        }
        return maxNum;
    }

    private boolean isNoticeMaxNum(String bankLoginID) {
        String customID;
        int maxNum = this.getNoticeMaxNum();
        if (maxNum == 0) {
            return false;
        }
        BankLoginLinkCheckRepository repository = SpringContextUtil.getBean(BankLoginLinkCheckRepository.class);
        int notifyCount = repository.getBLoginNoticeNum(customID = RequestContext.get().getTenantId(), bankLoginID);
        return notifyCount >= maxNum;
    }

    public static boolean checkAcntEnable(String accNo, String customID) {
        BankAcnt acnt = BankAcntService.getInstance().selectEnableByCustomIDAndAccNo(accNo, customID);
        return acnt != null;
    }
}

