/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.log.EBGLogger;

public class BizLogCleanUnit {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BizLogCleanUnit.class);
    private static DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private String deleteSql = "delete from t_aqap_biz_log where fopdate >= {ts'%s'} and fopdate < {ts'%s'}";
    private String queryParam = "opdate";
    private String oderBy = "opdate asc";

    public void execute(long days) {
        long betweenDays;
        if (days <= 0L) {
            return;
        }
        LocalDateTime fromDateTime = this.getEarlyDateBeforeToday();
        LocalDateTime toDayTime = LocalDateTime.now().minusDays(days);
        if (fromDateTime != null && fromDateTime.isBefore(toDayTime) && (betweenDays = ChronoUnit.DAYS.between(fromDateTime, toDayTime)) > 0L) {
            for (long i = 0L; i <= betweenDays; ++i) {
                LocalDateTime startDate = toDayTime.minusDays(i + 1L).with(LocalTime.MIDNIGHT);
                LocalDateTime endDate = toDayTime.minusDays(i).with(LocalTime.MIDNIGHT);
                String sql = String.format(this.deleteSql, startDate.format(YYYY_MM_DD_HH_MM_SS), endDate.format(YYYY_MM_DD_HH_MM_SS));
                this.executeKsql(sql);
            }
        }
    }

    private void executeKsql(String ksql) {
        TXHandle h = TX.requiresNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)"log"), (String)ksql);
        }
        catch (Throwable ex) {
            h.markRollback();
            throw ex;
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable e) {
                    this.logger.monitorError("TXHandle delete biz log close fail", e);
                }
            }
        }
    }

    public LocalDateTime getEarlyDateBeforeToday() {
        LocalDateTime tomorrow = LocalDateTime.now().plusDays(1L);
        StringBuilder querySqlBuilder = new StringBuilder();
        querySqlBuilder.append(this.queryParam).append(" < ?");
        QFilter filter = QFilter.of((String)querySqlBuilder.toString(), (Object[])new Object[]{tomorrow});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"aqap_biz_log", (String)this.queryParam, (QFilter[])filter.toArray(), (String)this.oderBy, (int)1);
        if (!collection.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(0);
            if (dynamicObject != null) {
                Date earlyDate = dynamicObject.getDate(this.queryParam);
                return LocalDateTime.ofInstant(earlyDate.toInstant(), ZoneId.systemDefault());
            }
            return null;
        }
        return null;
    }
}

