/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.task.BizLogCleanUnit;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.slf4j.MDC;

public class DetailArchiveTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailArchiveTask.class);
    DetailInfoService detailInfoService;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        this.detailInfoService = SpringContextUtil.getBean(DetailInfoService.class);
        this.logger.info("Detail Archive Task execute backup datas before 3 mouth ago.");
        try {
            this.detailInfoService.archiveDetailInfo(LocalDateTime.now().minusMonths(3L));
        }
        catch (Exception e) {
            this.logger.error("Detail Archive Task error.", (Throwable)e);
        }
        LocalDateTime today = LocalDateTime.now().with(LocalTime.MIDNIGHT);
        long days = Long.parseLong(BusinessPropertyConfig.getBizLogCleanDays());
        if (days > 0L) {
            BizLogCleanUnit bizLogCleanUnit = new BizLogCleanUnit();
            bizLogCleanUnit.execute(days);
            LocalDateTime bizLogEarlyDate = bizLogCleanUnit.getEarlyDateBeforeToday();
            if (bizLogEarlyDate != null) {
                this.clearEBGLog(bizLogEarlyDate.with(LocalTime.MIDNIGHT));
            } else {
                this.clearEBGLog(today.minusDays(days));
            }
        }
        this.clearHistoryTask(today.minusDays(7L));
    }

    private void clearHistoryTask(LocalDateTime queryDateTime) {
        String deleteSql = "delete from t_aqap_biz_task where fcreatetime >= ? and fcreatetime < ?";
        String queryParam = "createtime";
        String oderBy = "createtime asc";
        this.clearHistoryData(queryDateTime, "aqap_biz_task", deleteSql, queryParam, oderBy);
    }

    private void clearEBGLog(LocalDateTime queryDateTime) {
        String deleteSql = "delete from t_aqap_new_log where fdt_query >= ? and fdt_query < ?";
        String queryParam = "dt_query";
        String oderBy = "dt_query asc";
        this.clearHistoryData(queryDateTime, "aqap_new_log", deleteSql, queryParam, oderBy);
    }

    private void clearHistoryData(LocalDateTime lastDateTime, String entityName, String deleteSql, String queryParam, String orderBy) {
        long betweenDays;
        StringBuilder querySqlBuilder = new StringBuilder();
        querySqlBuilder.append(queryParam).append(" < ?");
        QFilter filter = QFilter.of((String)querySqlBuilder.toString(), (Object[])new Object[]{lastDateTime});
        LocalDateTime earlyDateTime = this.getEarlyDate(entityName, queryParam, filter.toArray(), orderBy);
        if (earlyDateTime != null && earlyDateTime.isBefore(lastDateTime) && (betweenDays = ChronoUnit.DAYS.between(earlyDateTime, lastDateTime)) > 0L) {
            Object[] params = new Object[2];
            for (long i = 0L; i <= betweenDays; ++i) {
                params[0] = lastDateTime.minusDays(i + 1L);
                params[1] = lastDateTime.minusDays(i);
                this.executeKsql(deleteSql, params);
            }
        }
    }

    private void executeKsql(String ksql, Object[] params) {
        TXHandle h = TX.requiresNew();
        try {
            DB.execute((DBRoute)DBRoute.of((String)"ebg"), (String)ksql, (Object[])params);
        }
        catch (Throwable ex) {
            h.markRollback();
            throw ex;
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable e) {
                    this.logger.monitorError("TXHandle close fail", e);
                }
            }
        }
    }

    private LocalDateTime getEarlyDate(String entityName, String param, QFilter[] filters, String orderBys) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)param, (QFilter[])filters, (String)orderBys, (int)1);
        if (!collection.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(0);
            Date earlyDate = dynamicObject.getDate(param);
            return LocalDateTime.ofInstant(earlyDate.toInstant(), ZoneId.systemDefault());
        }
        return null;
    }
}

