/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.monitor.LoginLinkCheckInfo;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class BankLoginLinkCheckRepository {
    String ENTITY_KEY = "aqap_login_link_check";
    String PROPERTIES = "custom_id,bank_version_id,bank_login_id,update_time,type,status,message,notify_time";

    public List<LoginLinkCheckInfo> findByCustomIDAndLoginAndSearchTime(String customID, String bankLoginID, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<LoginLinkCheckInfo> list = new ArrayList<LoginLinkCheckInfo>(16);
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and update_time >= ? and update_time <= ?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                list.add(this.transFormat(dynamicObject));
            }
        }
        return list;
    }

    public List<LoginLinkCheckInfo> findByCustomIDAndSearchTime(String customID, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<LoginLinkCheckInfo> list = new ArrayList<LoginLinkCheckInfo>();
        QFilter filter = QFilter.of((String)"custom_id=?  and update_time >= ? and update_time <= ?", (Object[])new Object[]{customID, startTime, endTime});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                list.add(this.transFormat(dynamicObject));
            }
        }
        return list;
    }

    public Map<String, List<LoginLinkCheckInfo>> findLastState(String customID) {
        HashMap<String, List<LoginLinkCheckInfo>> map = new HashMap<String, List<LoginLinkCheckInfo>>(16);
        Date now = new Date();
        QFilter filter = QFilter.of((String)"custom_id=? and update_time >= ?", (Object[])new Object[]{customID, DateUtil.getLastDay((Date)now, (int)1)});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time desc");
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                ArrayList<LoginLinkCheckInfo> list;
                String bankLoginID = dynamicObject.getString("bank_login_id");
                if (map.containsKey(bankLoginID)) {
                    list = (ArrayList<LoginLinkCheckInfo>)map.get(bankLoginID);
                } else {
                    list = new ArrayList<LoginLinkCheckInfo>(16);
                    map.put(bankLoginID, list);
                }
                list.add(this.transFormat(dynamicObject));
                Collections.sort(list);
            }
        }
        return map;
    }

    public List<LoginLinkCheckInfo> findLastState(String customID, String bankLoginId) {
        Date now = new Date();
        ArrayList<LoginLinkCheckInfo> list = new ArrayList<LoginLinkCheckInfo>();
        QFilter filter = QFilter.of((String)"custom_id=?  and bank_login_id=? and update_time >= ?", (Object[])new Object[]{customID, bankLoginId, DateUtil.getLastDay((Date)now, (int)1)});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time desc", (int)1);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                list.add(this.transFormat(dynamicObject));
            }
        }
        return list;
    }

    public Page<LoginLinkCheckInfo> findByStateAndSearchTime(String customID, String bankLoginID, String state, LocalDateTime startTime, LocalDateTime endTime, Pageable pageRequest) {
        QFilter filter;
        StringBuilder str;
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        PageImpl result = new PageImpl();
        ArrayList<LoginLinkCheckInfo> loginLinkCheckInfos = new ArrayList<LoginLinkCheckInfo>(1);
        if (StringUtils.isNotEmpty((String)state)) {
            str = new StringBuilder("custom_id=? and bank_login_id=? and status=? and update_time>=? and update_time<=?");
            filter = QFilter.of((String)str.toString(), (Object[])new Object[]{customID, bankLoginID, state, startTime, endTime});
        } else {
            str = new StringBuilder("custom_id=? and bank_login_id=? and update_time>=? and update_time<=?");
            filter = QFilter.of((String)str.toString(), (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time desc", (int)pageNumber, (int)pageSize);
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.ENTITY_KEY, (String)"id", (QFilter[])filter.toArray(), (String)"");
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                loginLinkCheckInfos.add(this.transFormat(dynamicObjects[i]));
            }
            long total = ds.count("id", Boolean.FALSE.booleanValue());
            result = new PageImpl(loginLinkCheckInfos, pageRequest, total);
        }
        return result;
    }

    public boolean isHasAlertIn30Min(String customID, String bankLoginID) {
        return this.isHasAlertInMin(customID, bankLoginID, 30L);
    }

    public boolean isHasAlertInMin(String customID, String bankLoginID, long min) {
        LocalDateTime startTime = LocalDateTime.now().minusMinutes(min);
        LocalDateTime endTime = LocalDateTime.now();
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and notify_time >= ? and notify_time <= ?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
        return QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
    }

    public boolean isHasChecked(String customID, String bankLoginID, LocalDateTime startTime, LocalDateTime endTime) {
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and update_time >= ? and update_time <= ?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
        return QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
    }

    public void save(LoginLinkCheckInfo info) {
        DynamicObject dynamicObject = this.transFormat(info);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteHistory(int historyDays) {
        LocalDateTime historyTime = LocalDateTime.now().minusDays(historyDays);
        QFilter filter = QFilter.of((String)"update_time <= ?", (Object[])new Object[]{historyTime});
        if (QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])filter.toArray())) {
            DeleteServiceHelper.delete((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
        }
    }

    private DynamicObject transFormat(LoginLinkCheckInfo info) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
        dynamicObject.set("custom_id", (Object)info.getCustomID());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("update_time", (Object)Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("type", (Object)info.getType());
        dynamicObject.set("status", (Object)info.getStatus());
        String message = StringUtils.substringChinese((String)info.getMessage(), (String)"UTF-8", (int)500);
        dynamicObject.set("message", (Object)message);
        if (info.getNotifyTime() != null) {
            dynamicObject.set("notify_time", (Object)Date.from(info.getNotifyTime().atZone(ZoneId.systemDefault()).toInstant()));
        }
        return dynamicObject;
    }

    private LoginLinkCheckInfo transFormat(DynamicObject dynamicObject) {
        LoginLinkCheckInfo info = new LoginLinkCheckInfo();
        info.setCustomID(dynamicObject.getString("custom_id"));
        info.setBankLoginID(dynamicObject.getString("bank_login_id"));
        info.setBankVersionID(dynamicObject.getString("bank_version_id"));
        info.setMessage(dynamicObject.getString("message"));
        info.setStatus(dynamicObject.getString("status"));
        String type = dynamicObject.getString("type");
        if ("active".equalsIgnoreCase(type)) {
            info.setType(ResManager.loadKDString((String)"\u4e3b\u52a8\u68c0\u6d4b", (String)"BankLoginLinkCheckRepository_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        } else if ("passive".equalsIgnoreCase(type)) {
            info.setType(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42", (String)"BankLoginLinkCheckRepository_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        } else {
            info.setType("-");
        }
        if (StringUtils.isEmpty((String)dynamicObject.getString("update_time"))) {
            info.setUpdateTime(LocalDateTime.now());
        } else {
            info.setUpdateTime(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("update_time")));
        }
        if (StringUtils.isEmpty((String)dynamicObject.getString("notify_time"))) {
            info.setUpdateTime(LocalDateTime.now().minusYears(100L));
        } else {
            info.setNotifyTime(DTFactoryUtil.parseDateTime((String)dynamicObject.getString("notify_time")));
        }
        return info;
    }

    public int getBLoginNoticeNum(String customID, String bankLoginID) {
        int count = 0;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime startTime = LocalDateTime.of(now.getYear(), now.getMonthValue(), now.getDayOfMonth(), 0, 0, 0);
        LocalDateTime endTime = LocalDateTime.now();
        QFilter filter = QFilter.of((String)"custom_id=? and bank_login_id=? and notify_time >= ? and notify_time <= ?", (Object[])new Object[]{customID, bankLoginID, startTime, endTime});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)this.PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null) {
            count = collection.size();
        }
        return count;
    }
}

