/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.acct.MappingTable;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class MappingAcctRepository {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(MappingAcctRepository.class);
    private final String ENTITY_NAME = "aqap_mapping_acct";
    private final String SELECT_PROPERTIES = "ID,parentacct,childacct,currency,swiftcode,reserve";

    public long getCountsByParentAcct(String parent) {
        QFilter qFilter = QFilter.of((String)"parentacct = ?", (Object[])new Object[]{parent});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray(), (String)"");
        return dataSet.count("id", Boolean.FALSE.booleanValue());
    }

    private DynamicObject packEntity(DynamicObject dynamicObject, MappingTable.TableStruct table, String parentAcct) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        } else {
            this.setDynamicParamater(dynamicObject, "id", Long.parseLong(table.getId()));
        }
        this.setDynamicParamater(dynamicObject, "parentacct", parentAcct);
        this.setDynamicParamater(dynamicObject, "childacct", table.getAccNo());
        this.setDynamicParamater(dynamicObject, "currency", table.getCurrency());
        this.setDynamicParamater(dynamicObject, "swiftcode", table.getSwiftCode());
        this.setDynamicParamater(dynamicObject, "reserve", table.getReserve());
        return dynamicObject;
    }

    private MappingTable.TableStruct unpackEntity(DynamicObject dynamicObject) {
        String childacct = dynamicObject.getString("childacct");
        String currency = dynamicObject.getString("currency");
        String swiftcode = dynamicObject.getString("swiftcode");
        String reserve = dynamicObject.getString("reserve");
        MappingTable.TableStruct tableStruct = new MappingTable.TableStruct();
        tableStruct.setAccNo(childacct);
        tableStruct.setCurrency(currency);
        tableStruct.setSwiftCode(swiftcode);
        tableStruct.setReserve(reserve);
        return tableStruct;
    }

    public MappingTable selectTableByAccAndCurrency(String acc, String cur) {
        QFilter qFilter = QFilter.of((String)"parentacct = ? and currency = ?", (Object[])new Object[]{acc, cur});
        Map maps = BusinessDataServiceHelper.loadFromCache((String)this.ENTITY_NAME, (String)"ID,parentacct,childacct,currency,swiftcode,reserve", (QFilter[])qFilter.toArray());
        MappingTable mappingTable = new MappingTable();
        ArrayList<MappingTable.TableStruct> childAccts = new ArrayList<MappingTable.TableStruct>(1);
        mappingTable.setChildAccts(childAccts);
        mappingTable.setParentAcct(acc);
        if (maps != null && maps.size() > 0) {
            for (Map.Entry entry : maps.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                childAccts.add(this.unpackEntity(dynamicObject));
            }
        }
        return mappingTable;
    }

    public void save(MappingTable mt) {
        if (mt.getChildAccts() == null || mt.getChildAccts().isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(4);
        String parentAcct = mt.getParentAcct();
        long count = this.getCountsByParentAcct(parentAcct);
        if (count > 0L) {
            this.delete(parentAcct);
        }
        for (MappingTable.TableStruct ts : mt.getChildAccts()) {
            dynamicObjects.add(this.packEntity(null, ts, parentAcct));
        }
        DynamicObject[] dynamicObjArray = dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjArray);
    }

    public int delete(String parentAcct) {
        QFilter qFilter = QFilter.of((String)"parentacct = ? ", (Object[])new Object[]{parentAcct});
        return DeleteServiceHelper.delete((String)this.ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }
}

