/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.PaymentInfoRecord;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;

@Component
public class PaymentInfoRecordRepository {
    private String entity = "aqap_bd_payment_record";
    private String properties = "payment_id,create_time,update_count,update_time";

    public PaymentInfoRecord findById(String id) {
        PaymentInfoRecord record = new PaymentInfoRecord();
        QFilter filter = QFilter.of((String)"payment_id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            record.setId(id);
            String time = dynamicObject.getString("create_time");
            if (!this.isEmpty(time)) {
                record.setCreateTime(DTFactoryUtil.parseDateTime((String)time));
            }
            if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
                record.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
            }
        } else {
            return null;
        }
        record.setUpdateCount(dynamicObject.getInt("update_count"));
        return record;
    }

    public Map<String, PaymentInfoRecord> findByIds(List<String> ids) {
        HashMap<String, PaymentInfoRecord> result = new HashMap<String, PaymentInfoRecord>(16);
        QFilter filter = new QFilter("payment_id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                PaymentInfoRecord record = new PaymentInfoRecord();
                record.setId(dynamicObject.getString("payment_id"));
                String time = dynamicObject.getString("create_time");
                if (!this.isEmpty(time)) {
                    record.setCreateTime(DTFactoryUtil.parseDateTime((String)time));
                }
                if (!this.isEmpty(time = dynamicObject.getString("update_time"))) {
                    record.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
                }
                record.setUpdateCount(dynamicObject.getInt("update_count"));
                result.put(record.getId(), record);
            }
        }
        return result;
    }

    public void save(List<PaymentInfoRecord> paymentInfoRecords, boolean isUpdate) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (PaymentInfoRecord record : paymentInfoRecords) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
            dynamicObject.set("payment_id", (Object)record.getId());
            dynamicObject.set("update_count", (Object)record.getUpdateCount());
            LocalDateTime time = record.getCreateTime();
            if (time != null) {
                dynamicObject.set("create_time", (Object)Date.from(time.atZone(ZoneId.systemDefault()).toInstant()));
            }
            if ((time = record.getUpdateTime()) != null) {
                dynamicObject.set("update_time", (Object)Date.from(time.atZone(ZoneId.systemDefault()).toInstant()));
            }
            dynamicObjectList.add(dynamicObject);
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        } else {
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

