/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.entity.bank.SameBankKeyWordEntity;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class SameBankKeyWordsRepository {
    private String BANK_KEYWORDS_ENTITY = "aqap_bank_same_word";
    private String SELECT_PROPERTIES = "id,modifytime,createtime,creator,modifier,enable,status,bank_key,bank_version";

    public List<String> findByBankVersion(String bankVersion) {
        QFilter filter = QFilter.of((String)"bank_version = ? ", (Object[])new Object[]{bankVersion});
        String selectProperties = "bank_key";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.BANK_KEYWORDS_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
        ArrayList<String> result = new ArrayList<String>();
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String bankKey = dynamicObject.getString("bank_key");
                result.add(bankKey);
            }
        }
        return result;
    }

    public void update(SameBankKeyWordEntity sameBankKeyWordEntity) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.BANK_KEYWORDS_ENTITY);
        dynamicObject = this.packInfo(dynamicObject, sameBankKeyWordEntity);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)this.BANK_KEYWORDS_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public long save(SameBankKeyWordEntity sameBankKeyWordEntity) {
        DynamicObject dynamicObject = null;
        dynamicObject = this.packInfo(dynamicObject, sameBankKeyWordEntity);
        DynamicObject[] dynamicObjects = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        if (dynamicObjects.length > 0) {
            dynamicObject = dynamicObjects[0];
            long id = dynamicObject.getLong("id");
            return id;
        }
        return 0L;
    }

    private DynamicObject packInfo(DynamicObject dynamicObject, SameBankKeyWordEntity entity) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.BANK_KEYWORDS_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)entity.getCreatorid());
        } else {
            dynamicObject.set("id", (Object)entity.getId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        dynamicObject.set("modifier", (Object)entity.getModifierid());
        dynamicObject.set("bank_key", (Object)entity.getBankKey());
        dynamicObject.set("bank_version", (Object)entity.getBankVersionId());
        dynamicObject.set("enable", (Object)entity.getEnable());
        dynamicObject.set("status", (Object)entity.getStatus());
        return dynamicObject;
    }

    public List<SameBankKeyWordEntity> findListByBankVersion(String bankVersion) {
        ArrayList<SameBankKeyWordEntity> result = new ArrayList<SameBankKeyWordEntity>(16);
        QFilter filter = QFilter.of((String)"bank_version = ?", (Object[])new Object[]{bankVersion});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.BANK_KEYWORDS_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                SameBankKeyWordEntity settleBankAccNoEntity = this.toEntityInfo(dynamicObject);
                result.add(settleBankAccNoEntity);
            }
        }
        return result;
    }

    private SameBankKeyWordEntity toEntityInfo(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        SameBankKeyWordEntity entity = new SameBankKeyWordEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        entity.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        String enable = dynamicObject.getString("enable");
        if (!StringUtils.isEmpty((String)enable)) {
            enable = enable.replace(" ", "");
            entity.setEnable(Integer.parseInt(enable));
        }
        String creatorid = dynamicObject.getString("creator");
        entity.setCreatorid(creatorid);
        String modifierid = dynamicObject.getString("modifier");
        entity.setCreatorid(modifierid);
        String status = dynamicObject.getString("status");
        if (StringUtils.isNotEmpty((String)status)) {
            status = status.replace(" ", "");
        }
        entity.setStatus(status);
        entity.setBankVersionId(dynamicObject.getString("bank_version"));
        entity.setBankKey(dynamicObject.getString("bank_key"));
        return entity;
    }
}

