/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class TCommon {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TCommon.class);

    public static String createCommonMsg(String xml) throws EBServiceException {
        int digital = 10;
        String msgBody = "00" + xml;
        int msgBodyLen = TCommon.getLength(msgBody);
        String msgHead = TCommon.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) throws EBServiceException {
        String encoding = TCommon.getEncoding();
        try {
            int length = str.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + encoding, (Throwable)e);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)false, (char)' ', (String)TCommon.getEncoding());
        }
        catch (Exception e) {
            logger.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)e);
            return "";
        }
    }

    public static String getEncoding() throws EBServiceException {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }

    public static BankResponse parseBankResponse(Element head) throws EBServiceException {
        BankResponse response = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String responseMessage = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%s\u3002", (String)"TCommon_9", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), ret_info);
        if (!StringUtils.isEmpty((String)ext_info)) {
            responseMessage = responseMessage + String.format(ResManager.loadKDString((String)"\uff1b\u94f6\u884c\u8fd4\u56de\u9644\u52a0\u4fe1\u606f\uff1a%1$s", (String)"TCommon_10", (String)"ebg-aqap-banks-sjb-cms", (Object[])new Object[0]), ext_info);
        }
        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);
        return response;
    }

    public static String[][] parseMFS(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

