/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sde.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sde.dc.utils.SDEPackerUtils;
import kd.ebg.aqap.banks.sde.dc.utils.SDEParserUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = SDEPackerUtils.createRootWithHead(request.getHeader().getRequestSeqID(), "B2EActBalQry");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Map2, (String)"TrsPassword", (String)RequestContextUtils.getParameter().getBankParameter("userPassword"));
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = SDEParserUtils.parseRspToRoot(responseStr);
        BankResponse rsp = SDEParserUtils.parseResponse(root);
        if (!"000000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u7801:,\u9519\u8bef\u4fe1\u606f:", (String)"TodayBalanceImpl_12", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element Body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element List2 = JDomUtils.getChildElement((Element)Body, (String)"List");
        List Map2 = List2.getChildren("Map");
        if (null == Map2 || Map2.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u6709\u8bef\u3002\u8fd4\u56de\u62a5\u6587\u4e2d\u7f3a\u5c11<Message/BodyList/Map>\u8282\u70b9\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u3002", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        for (int i = 0; i < Map2.size(); ++i) {
            Element map = (Element)Map2.get(i);
            String ReturnCode = JDomUtils.getChildTextNotNull((Element)map, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            String ReturnMsg = JDomUtils.getChildTextNotNull((Element)map, (String)"ReturnMsg", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u6d88\u606f", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            String AcNo = JDomUtils.getChildTextNotNull((Element)map, (String)"AcNo", (String)ResManager.loadKDString((String)"\u5e10\u53f7", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            String Currency = JDomUtils.getChildTextNotNull((Element)map, (String)"Currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd\u4ee3\u7801", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            String Balance = JDomUtils.getChildTextNotNull((Element)map, (String)"Balance", (String)ResManager.loadKDString((String)"\u5e10\u6237\u4f59\u989d", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            String AvailBal = JDomUtils.getChildTextNotNull((Element)map, (String)"AvailBal", (String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
            if (!"000000".equals(ReturnCode) || !request.getAcnt().getAccNo().equals(AcNo)) continue;
            balanceInfo.setBankAcnt(request.getAcnt());
            balanceInfo.setBankCurrency(Currency);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            this.setCurrentBalance(balanceInfo, Balance);
            this.setAvailableBalance(balanceInfo, AvailBal);
            break;
        }
        if (null == balanceInfo.getBankAcnt()) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u6709\u8bef\u3002\u672a\u6b63\u786e\u8fd4\u56de\u8d26\u53f7[%1$s,%2$s]\u7684\u4f59\u989d\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u3002", (String)"TodayBalanceImpl_13", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), request.getAcnt().getAccName(), request.getAcnt().getAccNo());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_11", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2EActBalQry").append(".do?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

