/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.card;

import java.net.URL;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.card.CardOfBeiJing;
import kd.ebg.aqap.banks.icbc.cmp.card.CardWithAreaCode;
import kd.ebg.aqap.banks.icbc.cmp.card.CardWithBranchCode;
import kd.ebg.aqap.banks.icbc.cmp.card.CardWithHandle;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class CardWithsHandleStore {
    private static CardWithsHandleStore instance;
    public static final String fileName = "AresCode.xml";
    private CardWithHandle[] cardTypes;

    public static CardWithsHandleStore getInstance() {
        if (null == instance) {
            instance = new CardWithsHandleStore();
        }
        return instance;
    }

    private CardWithsHandleStore() {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            doc = builder.build(resource);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        Element root = doc.getRootElement();
        List cardtypeList = root.getChildren("cardtype");
        this.cardTypes = new CardWithHandle[cardtypeList.size()];
        block7: for (int i = 0; i < this.cardTypes.length; ++i) {
            Element cardType = (Element)cardtypeList.get(i);
            String cardid = cardType.getChildTextTrim("cardid");
            String areaType = cardType.getChildTextTrim("AreaType");
            String start = cardType.getChildTextTrim("start");
            int typeNo = -1;
            int startIndex = -1;
            if (!StrUtil.isEmpty((String)areaType)) {
                typeNo = Integer.parseInt(areaType);
            }
            if (!StrUtil.isEmpty((String)start)) {
                startIndex = Integer.parseInt(start);
            }
            switch (typeNo) {
                case 0: {
                    this.cardTypes[i] = new CardOfBeiJing(cardid, typeNo);
                    continue block7;
                }
                case 1: {
                    this.cardTypes[i] = new CardWithBranchCode(cardid, typeNo, startIndex);
                    continue block7;
                }
                case 2: {
                    this.cardTypes[i] = new CardWithAreaCode(cardid, typeNo, startIndex);
                    continue block7;
                }
                default: {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u7c7b\u578b%s\u3002", (String)"CardWithsHandleStore_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), typeNo));
                }
            }
        }
    }

    public CardWithHandle[] getCardTypes() {
        return this.cardTypes;
    }
}

