/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service;

import java.io.IOException;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBC_CMP_FailErrorCodes;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBC_CMP_ResultMap;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.ZipUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ICBC_CMP_PayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_PayParser.class);

    public static void parsePay(List<PaymentInfo> paymentInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String simplifyRspCode4Cpic = parameter.getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String fSeqno = pub.getChild("fSeqno").getText();
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (ICBC_CMP_FailErrorCodes.isFailed(headRsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
            return;
        }
        Element out = eb.getChild("out");
        if (null == out) {
            if (0 != paymentInfos.size()) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u6279\u91cf\u4ed8\u6b3e\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"ICBC_CMP_PayParser_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                return;
            }
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return;
        }
        List list = out.getChildren("rd");
        ICBC_CMP_PayParser.parsePayRd(paymentInfos, cpic, fSeqno, list);
    }

    public static void parsePayNew(List<PaymentInfo> paymentInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String simplifyRspCode4Cpic = parameter.getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String fSeqno = pub.getChild("fSeqno").getText();
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (ICBC_CMP_FailErrorCodes.isFailed(headRsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
            return;
        }
        Element out = eb.getChild("out");
        String qryfSeqNo = eb.getChildTextTrim("QryfSeqno");
        if (out == null) {
            if (!paymentInfos.isEmpty()) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u6279\u91cf\u4ed8\u6b3e\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"ICBC_CMP_PayParser_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                return;
            }
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return;
        }
        List list = null;
        String zipStr = out.getChildText("zip");
        if (zipStr != null) {
            try {
                byte[] zipByte = ZipUtils.unZipandUnbase64(zipStr);
                String zipContent = new String(zipByte, EBContext.getContext().getCharsetName());
                zipContent = "<zip>" + zipContent + "</zip>";
                logger.info("\u89e3\u538b\u7f29\u94f6\u884c\u8fd4\u56de\u660e\u6587\uff1a" + zipContent);
                Element zip = JDomUtils.string2Root((String)zipContent, (String)EBContext.getContext().getCharsetName());
                list = zip.getChildren("rd");
            }
            catch (IOException localIOException) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29zip\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ICBC_CMP_PayParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29zip\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ICBC_CMP_PayParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)localIOException);
            }
        } else {
            list = out.getChildren("rd");
        }
        ICBC_CMP_PayParser.parsePayRd(paymentInfos, cpic, fSeqno, list);
    }

    private static void parsePayRd(List<PaymentInfo> paymentInfos, boolean cpic, String fSeqno, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Element rd = (Element)list.get(i);
            String iSeqno = rd.getChildText("iSeqno");
            String iRetCode = rd.getChildText("iRetCode");
            String iRetMsg = rd.getChildText("iRetMsg");
            String result = rd.getChildText("Result");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)fSeqno, (String)iSeqno);
            if (null == paymentInfo) continue;
            String bankStatus = "";
            bankStatus = cpic ? iRetCode : "<iRetCode>" + iRetCode + "</iRetCode> <Result>" + result + "</Result>";
            paymentInfo.setBankStatus(bankStatus);
            if (StringUtils.isEmpty((String)iRetMsg)) {
                paymentInfo.setStatusMsg(ICBC_CMP_ResultMap.convertResult2Advice(result));
            } else {
                paymentInfo.setBankMsg(iRetMsg);
            }
            if ("7".equalsIgnoreCase(result)) {
                paymentInfo.setBackStatus(paymentInfo.getStatus());
                paymentInfo.setStatus(Integer.valueOf(PaymentState.SUCCESS.getId()));
                paymentInfo.setStatusName(PaymentState.SUCCESS.getEnName());
                paymentInfo.setStatusMsg(PaymentState.SUCCESS.getCnName());
                continue;
            }
            if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result)) {
                paymentInfo.setBackStatus(paymentInfo.getStatus());
                paymentInfo.setStatus(Integer.valueOf(PaymentState.FAIL.getId()));
                paymentInfo.setStatusName(PaymentState.FAIL.getEnName());
                paymentInfo.setStatusMsg(PaymentState.FAIL.getCnName());
                if (!"B0083".equalsIgnoreCase(iRetCode)) continue;
                paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\u5efa\u8bae\u60a8\u68c0\u67e5\u6536\u6b3e\u8d26\u53f7,\u4ed8\u6b3e\u5931\u8d25\u7684\u539f\u56e0\u53ef\u80fd\u662f:\u5de5\u884c\u7684\u540c\u884c\u652f\u4ed8\u65f6,\u6536\u6b3e\u8d26\u53f7\u586b\u5199\u9519\u8bef", (String)"ICBC_CMP_PayParser_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
                continue;
            }
            paymentInfo.setBackStatus(paymentInfo.getStatus());
            paymentInfo.setStatus(Integer.valueOf(PaymentState.SUBMITED.getId()));
            paymentInfo.setStatusName(PaymentState.SUBMITED.getEnName());
            paymentInfo.setStatusMsg(PaymentState.SUBMITED.getCnName());
        }
    }

    public static String getRef(String bankDetailSeqId) {
        return BizNoUtil.prefix_cont((String)bankDetailSeqId);
    }
}

