/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolBalanceUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CashPoolBalanceUtil.class);
    private static final String transCode = "QFACCTMEAS";

    public static void queryAvailableBalance(BalanceInfo balance, String accNo) {
        try {
            String rqstStr = CashPoolBalanceUtil.packMessage(accNo);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/servlet/ICBCCMPAPIReqServlet");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                try (InputStream is = conn.getInputStream();){
                    String rspStr = IOUtils.readFully((InputStream)is);
                    CashPoolBalanceUtil.parseMessage(balance, rspStr);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private static String packMessage(String accNo) {
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)accNo);
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode);
    }

    private static void parseMessage(BalanceInfo balance, String responseStr) {
        String encoding;
        String retMsg = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        Element root = JDomUtils.string2Root((String)retMsg, (String)(encoding = EBContext.getContext().getCharsetName()));
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u4fe1\u606f\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"CashPoolBalanceUtil_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StrUtil.join((String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage()));
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element out = eb.getChild("out");
        String currType = eb.getChildTextTrim("CurrType");
        if (!currType.equalsIgnoreCase(balance.getBankCurrency())) {
            return;
        }
        if (BankBusinessConfig.isAvailableBalanceFromQFACCTMEASAvaPayAmt()) {
            String AvaPayAmt = JDomUtils.getChildText((Element)out, (String)"AvaPayAmt");
            logger.info("\u89e3\u6790\u5230\u5de5\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u8d26\u53f7\u53ef\u652f\u4ed8\u91d1\u989d'\u4e3a" + AvaPayAmt + "\u5206");
            balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)AvaPayAmt));
        } else if (BankBusinessConfig.isAvailableBalanceFromQFACCTMEASReserved2()) {
            String RepReserved2 = JDomUtils.getChildText((Element)out, (String)"RepReserved2");
            String[] RepReserved2Arr = RepReserved2.split("\\|", -1);
            if (RepReserved2Arr.length >= 4) {
                logger.info("\u89e3\u6790\u5230\u5de5\u884c\u8fd4\u56de\u7684'\u6210\u5458\u8d26\u6237\u5df2\u501f\u51fa\u6b3e\u91d1\u989d'\u4e3a" + RepReserved2Arr[2] + "\u5206");
                balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)RepReserved2Arr[2]));
            }
        } else {
            String ABanlance = JDomUtils.getChildText((Element)out, (String)"ABanlance");
            logger.info("\u89e3\u6790\u5230\u5de5\u884c\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + ABanlance + "\u5206");
            balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)ABanlance));
        }
    }
}

