/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import java.io.InputStream;
import java.io.OutputStream;
import kd.ebg.aqap.banks.icbc.cmp.service.balance.QFACCTMEASPacker;
import kd.ebg.aqap.banks.icbc.cmp.service.balance.QFACCTMEASParser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;

public class QFACCTMEASImpl {
    public void queryAvailableBalance(BalanceInfo balance, String accNo) {
        QFACCTMEASPacker packer = new QFACCTMEASPacker();
        QFACCTMEASParser parser = new QFACCTMEASParser();
        try {
            String rqstStr = packer.packQFACCTMEASMessage(accNo);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/servlet/ICBCCMPAPIReqServlet");
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                IOUtils.closeOutputStreamQuietly((OutputStream)os);
                try (InputStream is = conn.getInputStream();){
                    String rspStr = IOUtils.readFully((InputStream)is);
                    IOUtils.closeInputStreamQuietly((InputStream)is);
                    parser.parseQFACCTMEASMessage(balance, rspStr);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

