/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.curandfixed.query.queryatc;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryNotiiToCurImpl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(this.getBizCode(), ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)curAndFixedInfo.getBatchSeqId());
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"BeginDate", (String)curAndFixedInfo.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)in, (String)"EndDate", (String)curAndFixedInfo.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = "GBK";
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHeadForPay(reqstMsg, this.getBizCode(), "0.0.0.1", 0, ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(s, true);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        Element out = eb.getChild("out");
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode()) || out == null) {
            CAFUtil.setState((List)cafInfos, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)"", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            ebBankCurAndFixedResponse.setDetails(cafInfos);
            return ebBankCurAndFixedResponse;
        }
        List rds = out.getChildren("rd");
        for (Object o : rds) {
            Element rd = (Element)o;
            String iRetCode = rd.getChildText("iRetCode");
            String iRetMsg = rd.getChildText("iRetMsg");
            String result = rd.getChildText("Result");
            String NewCheckNo = rd.getChildText("NewCheckNo");
            if ("7".equalsIgnoreCase(result)) {
                curAndFixedInfo.setReqNbrWithTag(NewCheckNo);
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUCCESS, (String)"", (String)iRetCode, (String)iRetMsg);
                continue;
            }
            if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result)) {
                CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.FAIL, (String)"", (String)iRetCode, (String)iRetMsg);
                continue;
            }
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)"", (String)iRetCode, (String)iRetMsg);
        }
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QRYZQTZ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u53d6\u901a\u77e5\u6307\u4ee4\u67e5\u8be2\u3002", (String)"QueryNotiiToCurImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }
}

