/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.curandfixed.query.querycta;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryNotiiDetailImpl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(this.getBizCode(), ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AcctNo", (String)curAndFixedInfo.getFixedAccNo());
        JDomUtils.addChild((Element)in, (String)"CurrType", (String)curAndFixedInfo.getCurrency());
        JDomUtils.addChild((Element)in, (String)"BeginDate", (String)curAndFixedInfo.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)in, (String)"EndDate", (String)curAndFixedInfo.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = "GBK";
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHeadForPay(reqstMsg, this.getBizCode(), "0.0.0.1", 0, ((CurAndFixedInfo)cafInfos.get(0)).getBatchSeqId());
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(s, true);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        Element out = eb.getChild("out");
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode()) || out == null) {
            ebBankCurAndFixedResponse.setDetails(cafInfos);
            return ebBankCurAndFixedResponse;
        }
        List rds = out.getChildren("rd");
        String bal = out.getChildTextTrim("Balance");
        for (int i = 0; i < rds.size(); ++i) {
            Element rd = (Element)rds.get(i);
            String checkNo = rd.getChildTextTrim("CheckNo");
            if (!checkNo.equalsIgnoreCase(curAndFixedInfo.getReqNbrWithoutTag())) continue;
            String openDate = rd.getChildTextTrim("OpenDate");
            String beginDebtDate = rd.getChildTextTrim("BeginDebtDate");
            String rate = rd.getChildTextTrim("Rate");
            String dealLine = rd.getChildTextTrim("DealLine");
            String closeDate = rd.getChildTextTrim("CloseDate");
            String cRate = rd.getChildTextTrim("CRate");
            curAndFixedInfo.setOpenDate(openDate.replace("-", ""));
            curAndFixedInfo.setRateDate(beginDebtDate.replace("-", ""));
            curAndFixedInfo.setCloseInt(cRate);
            BigDecimal rateBig = new BigDecimal(rate);
            BigDecimal divide = rateBig.divide(new BigDecimal("1000000"), 5, 1);
            curAndFixedInfo.setRate(divide.toString());
            curAndFixedInfo.setEndDate(dealLine.replace("-", ""));
            curAndFixedInfo.setCloseDate(closeDate.replace("-", ""));
            curAndFixedInfo.setAccBal(bal);
        }
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QRYTZINFO";
    }

    public String getBizDesc() {
        return null;
    }
}

