/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.individualnew;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_PayParser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.UseConvertor;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individualnew.PAYPERIndividualNewQueryPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.ZipUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PAYPERIndividualNewPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PAYPERIndividualNewPayImpl.class);
    private static final String transCode = "PAYPER";

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return PAYPERIndividualNewQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return transCode;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u300a\u4f01\u4e1a\u8d22\u52a1\u5ba4\u6307\u4ee4\u63d0\u4ea4.xls\u300b\u548c\u300a\u4f01\u4e1a\u8d22\u52a1\u5ba4\u6307\u4ee4\u67e5\u8be2.xls\u300b\u662f\u60a8\u7684\u8d22\u52a1\u5ba4\u5fc5\u5907\u5de5\u5177\uff1b\u4ea4\u6613\u7801\u5206\u522b\u4e3aPAYPER\u548cQPAYPER\u3002", (String)"PAYPERIndividualNewPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !(!"pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getIndividual() == false || !BankBusinessConfig.isUseZipInterface() || !BankBusinessConfig.isFinance() && paymentInfo.getMerge() != false);
    }

    public String pack(BankPayRequest request) {
        BigDecimal totalAmt = new BigDecimal("0.00");
        List paymentInfos = request.getPaymentInfos();
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"OnlBatF", (String)"1");
        if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"2");
        } else {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"0");
        }
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)"");
        String signDate4Test = EBContext.getContext().getParameter().getBankParameter("signDate4Test");
        if (StrUtil.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"THBaseAccFlag", (String)"0");
        JDomUtils.addChild((Element)in, (String)"RegSerialNO", (String)"");
        StringBuilder rdStr = new StringBuilder();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element rd = new Element("rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)((PaymentInfo)paymentInfos.get(i)).getBankSerialNo());
            JDomUtils.addChild((Element)rd, (String)"ReimburseNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReimburseNum", (String)"");
            JDomUtils.addChild((Element)rd, (String)"StartDate", (String)"");
            JDomUtils.addChild((Element)rd, (String)"StartTime", (String)"");
            JDomUtils.addChild((Element)rd, (String)"PayType", (String)(((PaymentInfo)paymentInfos.get(i)).getUrgent() != false ? "1" : "2"));
            JDomUtils.addChild((Element)rd, (String)"PayAccNo", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameCN", (String)((PaymentInfo)paymentInfos.get(i)).getAccName());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameEN", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecAccNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameCN", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameEN", (String)"");
            if (!((PaymentInfo)paymentInfos.get(i)).getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"1");
            }
            JDomUtils.addChild((Element)rd, (String)"IsSameCity", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecICBCCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecCityName", (String)CommonUtils.substringChinese(StrUtil.trim((CharSequence)((PaymentInfo)paymentInfos.get(i)).getIncomeBankAddress()), 40));
            JDomUtils.addChild((Element)rd, (String)"RecBankNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            JDomUtils.addChild((Element)rd, (String)"RecBankName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            JDomUtils.addChild((Element)rd, (String)"PayAmt", (String)PackerUtils.convertYuan2CentStr((BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)rd, (String)"UseCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"UseCN", (String)UseConvertor.convert2ICBCUseCn((PaymentInfo)paymentInfos.get(i), transCode));
            JDomUtils.addChild((Element)rd, (String)"EnSummary", (String)"");
            if (CommonUtils.purposeOrSummary("3")) {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)"");
            } else if (BankBusinessConfig.isPostScriptIntercept()) {
                String PostScript = "";
                PostScript = !((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 60) : CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 100);
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)PostScript);
            } else {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            }
            String Summary = ((PaymentInfo)paymentInfos.get(i)).getExplanation();
            Summary = CommonUtils.substringChinese(StrUtil.trim((CharSequence)Summary), 20);
            JDomUtils.addChild((Element)rd, (String)"Summary", (String)(CommonUtils.purposeOrSummary("2") ? "" : Summary));
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankBatchSeqId()));
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId()));
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)rd, (String)"Oref", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPSqn", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqID());
            JDomUtils.addChild((Element)rd, (String)"BusCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPcheckno", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhType", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhName", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhNo", (String)"");
            rdStr.append(JDomUtils.element2StringPlain((Element)rd, (String)EBContext.getContext().getCharsetName()));
        }
        try {
            String rdMsg = rdStr.toString();
            logger.info("\u538b\u7f29\u524d\u7684\u4ed8\u6b3e\u62a5\u6587\u4e3a\uff1a" + rdMsg);
            String zipStr = ZipUtils.zipandBase64(rdMsg.getBytes(EBContext.getContext().getCharsetName()));
            JDomUtils.addChild((Element)in, (String)"zip", (String)zipStr);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6 : %s\u3002", (String)"PAYPERIndividualNewPayImpl_3", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), EBContext.getContext().getCharsetName()), (Throwable)e);
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u538b\u7f29\u51fa\u73b0\u5f02\u5e38", (String)"PAYPERIndividualNewPayImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        in.getChild("TotalAmt").setText(PackerUtils.convertYuan2CentStr((BigDecimal)totalAmt));
        String encoding = EBContext.getContext().getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, transCode, "0.0.1.0", 1, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ICBC_CMP_PayParser.parsePayNew(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

