/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szsrcb.cmp.services.balance;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Common;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "03020101A0008";
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankBalanceRequest.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        xmlMsg = Common.createCommonMsg(xmlMsg);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = ap.getChild("body");
        Element dto = body.getChild("dto");
        String balance = dto.getChildTextTrim("bookBal");
        String avaliableBal = dto.getChildTextTrim("avaliableBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (!StringUtils.isEmpty((String)balance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
        }
        if (!StringUtils.isEmpty((String)avaliableBal)) {
            balanceInfo.setAvailableBalance(new BigDecimal(avaliableBal));
        }
        result.add(balanceInfo);
        return new EBBankBalanceResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

