/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.payment.allocation;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.global.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.global.service.Packer;
import kd.ebg.aqap.banks.boc.net.global.service.Parser;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.global.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "b2e0041";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u8d26\u6237\u8f6c\u8d26\u6c47\u5212", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(PaymentInfo info) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List paymentInfos = request.getPaymentInfos();
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0041");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0041-rq");
            JDomUtils.addChild((Element)trn, (String)"transtype", (String)"");
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0041-rq");
                JDomUtils.addChild((Element)rq, (String)"insid", (String)BocNetUtils.getBankDetailSeqId(info));
                JDomUtils.addChild((Element)rq, (String)"cltype", (String)info.getSettlementMethod());
                Element fractn = JDomUtils.addChild((Element)rq, (String)"fractn");
                JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)info.getAreaCode());
                JDomUtils.addChild((Element)fractn, (String)"actacn", (String)info.getAccNo());
                JDomUtils.addChild((Element)fractn, (String)"curcde", (String)info.getCurrency());
                Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
                JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeSwiftCode());
                JDomUtils.addChild((Element)toactn, (String)"toactacn", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)toactn, (String)"toacctype", (String)"");
                JDomUtils.addChild((Element)toactn, (String)"toname", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)toactn, (String)"tobknm", (String)info.getIncomeBankName());
                JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)info.getIncomeAddress());
                JDomUtils.addChild((Element)toactn, (String)"tocity", (String)info.getIncomeCity());
                String incomeCountry = info.getIncomeCountry();
                CountryISOCode isoCode = ISOCountryUtils.getInstance().getCountryInfo(incomeCountry);
                if (isoCode == null) {
                    isoCode = ISOCountryUtils.getInstance().getCountryInfoByName(incomeCountry);
                }
                JDomUtils.addChild((Element)toactn, (String)"tocountry", (String)isoCode.geteChart2());
                JDomUtils.addChild((Element)rq, (String)"trnamt", (String)info.getAmount().setScale(2, 4).toString());
                JDomUtils.addChild((Element)rq, (String)"trncur", (String)CurrencyUtils.convert2Bank((String)info.getPayCurrency()));
                JDomUtils.addChild((Element)rq, (String)"amtype", (String)"3");
                JDomUtils.addChild((Element)rq, (String)"payeechnnam", (String)"");
                JDomUtils.addChild((Element)rq, (String)"payeeidtype", (String)"");
                JDomUtils.addChild((Element)rq, (String)"payeeidnum", (String)"");
                JDomUtils.addChild((Element)rq, (String)"payeephone", (String)info.getMobiles());
                JDomUtils.addChild((Element)rq, (String)"cuspriolv", (String)(info.getUrgent() != false ? "1" : "0"));
                JDomUtils.addChild((Element)rq, (String)"furinfo", (String)info.getExplanation());
                LocalDateTime now = LocalDateTime.now();
                if (null != info.getBookingTime() && info.getBookingTime().isAfter(now)) {
                    JDomUtils.addChild((Element)rq, (String)"trfdate", (String)info.getBookingTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                    PaymentUtil.setBookPayFlag((PaymentInfo)info);
                } else {
                    JDomUtils.addChild((Element)rq, (String)"trfdate", (String)now.toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                }
                String feeMode = "OUR";
                if ("02".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "BEN";
                } else if ("03".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "SHA";
                }
                JDomUtils.addChild((Element)rq, (String)"feemode", (String)feeMode);
                PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)BocNetUtils.getSeqIdFromInsid(info.getBankDetailSeqID()));
                JDomUtils.addChild((Element)rq, (String)"exchangeto", (String)"");
                String remittanceuse = info.getBusinessTypeCode();
                JDomUtils.addChild((Element)rq, (String)"remittanceuse", (String)remittanceuse);
                JDomUtils.addChild((Element)rq, (String)"paymentdetails", (String)"");
                JDomUtils.addChild((Element)rq, (String)"businesstype", (String)"");
                JDomUtils.addChild((Element)rq, (String)"agencyswiftcode", (String)"");
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos = request.getPaymentInfos());
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0041-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0041-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            String obssid = rs.getChildTextTrim("obssid");
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid(insid));
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"obssid", (String)obssid);
            if (null == info) continue;
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

