/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc.services.handler;

import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT940Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field20;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field28C;
import kd.ebg.aqap.proxy.swift.model.field.Field60F;
import kd.ebg.aqap.proxy.swift.model.field.Field60M;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field62F;
import kd.ebg.aqap.proxy.swift.model.field.Field64;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CITI_DC_MT940_Handler
extends AbstractMT940Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CITI_DC_MT940_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("MT940");
    }

    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List list = super.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.parseHistoryDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u524d\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"CITI_DC_MT940_Handler_2", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), name, e));
        }
    }

    private void parseHistoryDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        BigDecimal openingBalance;
        LocalDate date;
        List<OverseaDetail> list;
        Field20 field20 = new Field20(swiftTextBlock.getTagValue("20"));
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        Field28C field28C = new Field28C(swiftTextBlock.getTagValue("28C"));
        Field60F field60F = new Field60F(swiftTextBlock.getTagValue("60F"));
        Field60M field60M = new Field60M(swiftTextBlock.getTagValue("60M"));
        Field62F field62F = new Field62F(swiftTextBlock.getTagValue("62F"));
        this.logger.info("Field62F:" + field62F.toString());
        this.logger.info("Field20:" + field20.toString());
        this.logger.info("Field25:" + field25.toString());
        this.logger.info("Field28C:" + field28C.toString());
        this.logger.info("Field60F:" + field60F.toString());
        this.logger.info("Field60M:" + field60M.toString());
        String acntNumber = field25.getComponent1();
        String currency = field60F.getComponent3();
        if (StringUtils.isEmpty((String)currency)) {
            currency = field60M.getComponent3();
        }
        if ((list = this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList, date = field62F.getComponent2AsCalendar().getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())).size() > 0) {
            for (OverseaDetail info : list) {
                info.setCreatetime(LocalDateTime.now());
            }
            detailInfoList.addAll(list);
        }
        Field64 field64 = new Field64(swiftTextBlock.getTagValue("64"));
        this.logger.info("Field64:" + field64.toString());
        try {
            openingBalance = field60F.getComponent4AsBigDecimal();
            String balSign = field60F.getComponent1AsString();
            if (null == openingBalance) {
                openingBalance = field60M.getComponent4AsBigDecimal();
                balSign = field60M.getComponent1AsString();
            }
            if ("D".equalsIgnoreCase(balSign)) {
                openingBalance = openingBalance.multiply(new BigDecimal("-1"));
            }
        }
        catch (Exception e) {
            this.logger.info(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5386\u53f2\u660e\u7ec6Opening Balance \u4f59\u989d\u5931\u8d25%1$s\u3002", (String)"CITI_DC_MT940_Handler_1", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), e));
            throw e;
        }
        this.calcBalance(detailInfoList, openingBalance, acntNumber);
        Calendar balanceDate = field62F.getComponent2AsCalendar();
        LocalDateTime localDateTime = balanceDate.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        BigDecimal closingBalance = field62F.getComponent4AsBigDecimal();
        BigDecimal closingAvailableBalance = field64.getComponent4AsBigDecimal();
        OverseaBalance balanceInfo = new OverseaBalance();
        balanceInfo.setNumber(acntNumber);
        balanceInfo.setCurrency(currency);
        balanceInfo.setCurrentBalance(closingBalance);
        balanceInfo.setAvailableBalance(closingAvailableBalance);
        balanceInfo.setLastDayBalance(openingBalance);
        balanceInfo.setBalanceDate(localDateTime);
        balanceInfo.setUpdateSource(fileName);
        balanceInfoList.add(balanceInfo);
    }

    private List<OverseaDetail> parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, LocalDate transTime) {
        List tags = swiftTextBlock.getTags();
        ArrayList<OverseaDetail> list = new ArrayList<OverseaDetail>();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return list;
        }
        for (int aTag61Index : tag61Index) {
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            String onlyId = field61.toString().replaceAll(", ", "");
            onlyId = onlyId.substring(1, onlyId.length() - 1);
            OverseaDetail detail = new OverseaDetail();
            detail.setDetail_no(onlyId);
            detail.setNumber(acntNumber);
            detail.setPayBankName("CITI");
            detail.setPayBankVersion(this.context.getBankVersionID());
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCustomId(EBContext.getContext().getCustomID());
            detail.setTxDate(transTime);
            detail.setCurrency(currency);
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit) || "EC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit) || "ED".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else if ("RC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else if ("RD".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411\u3002", (String)"CITI_DC_MT942_Handler_3", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), creditOrDebit));
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            this.logger.info("Field61:" + field61.toString());
            String transType = field61.getComponent6();
            detail.setTransType(transType);
            if ("NCHK".equals(transType)) {
                detail.setPayid(field61.getComponent9());
            } else if ("NTRF".equals(transType)) {
                detail.setPayid(custRef);
            }
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                Field86 field86 = new Field86(tag86.getTagValue());
                this.logger.info("Field86:" + field86.toString());
                StringBuilder str = new StringBuilder();
                List field86List = field86.getComponents();
                for (String fie : field86List) {
                    if (StringUtils.isEmpty((String)fie) || "null".equals(fie)) continue;
                    str.append(fie);
                }
                detail.setExplanation(str.toString());
                if ("DEBIT".equals(detail.getCordFlag())) {
                    this.parseField86Payment(str.toString(), detail);
                } else {
                    this.parseField86Collect(str.toString(), detail);
                }
                if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
                    detail.setBenefitAccName("");
                }
            }
            try {
                PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId((String)custRef);
                if (paymentInfo != null) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CITI_DC_MT940_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CITI_DC_MT940_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
            }
            catch (Exception e) {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s\u3002", (String)"CITI_DC_MT942_Handler_4", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), e));
            }
            if (field61.getComponent9().contains("ZERO BALANCE TRANSACTION")) {
                list.add(detail);
                continue;
            }
            detailInfoList.add(detail);
        }
        return list;
    }

    private void parseField86Payment(String field86, OverseaDetail detail) {
        String str;
        int begin = field86.indexOf("/BI/");
        if (begin != -1) {
            str = field86.substring(begin + 4);
            String accNo = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccNo(accNo);
        }
        if ((begin = field86.indexOf("/BN/")) != -1) {
            str = field86.substring(begin + 4);
            String accName = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccName(accName);
        }
        if ((begin = field86.indexOf("/AB/")) != -1) {
            str = field86.substring(begin + 4);
            String bankName = str.substring(0, str.indexOf("/"));
            detail.setBenefitBankName(bankName);
        }
    }

    private void parseField86Collect(String field86, OverseaDetail detail) {
        int begin = field86.indexOf("/BO1/");
        int begin2 = field86.indexOf("/OB1/");
        if (begin != -1) {
            String str = field86.substring(begin + 5);
            String accName = str.substring(0, str.indexOf("/"));
            detail.setBenefitAccName(accName);
            begin = field86.indexOf("/BO/");
            if (begin != -1) {
                str = field86.substring(field86.indexOf("/BO/") + 4);
                String accNo = str.substring(0, str.indexOf("/"));
                accNo = Pattern.compile("[^(0-9)]").matcher(accNo).replaceAll("").trim();
                detail.setBenefitAccNo(accNo);
            }
            if ((begin = field86.indexOf("/OB/")) != -1) {
                str = field86.substring(begin + 4);
                String bankName = str.substring(0, str.indexOf("/"));
                detail.setBenefitBankName(bankName);
            }
        } else if (begin2 != -1) {
            String str = field86.substring(begin2 + 5);
            String bankName = str.substring(0, str.indexOf("/"));
            detail.setBenefitBankName(bankName);
            begin2 = field86.indexOf("/OB/");
            if (begin2 != -1) {
                str = field86.substring(field86.indexOf("/OB/") + 4);
                String accNo = str.substring(0, str.indexOf("/"));
                accNo = Pattern.compile("[^(0-9)]").matcher(accNo).replaceAll("").trim();
                detail.setBenefitAccNo(accNo);
            }
            if ((begin2 = field86.indexOf("/BO/")) != -1) {
                str = field86.substring(field86.indexOf("/BO/") + 4);
                String accName = str.substring(0, str.indexOf("/"));
                detail.setBenefitAccName(accName);
            }
        } else {
            this.logger.info(ResManager.loadKDString((String)"\u4e0d\u4fee\u6539", (String)"CITI_DC_MT942_Handler_5", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]));
        }
    }

    private void calcBalance(List<OverseaDetail> detailList, BigDecimal currentValue, String accNo) {
        HashSet<LocalDate> set = new HashSet<LocalDate>(16);
        for (OverseaDetail info : detailList) {
            set.add(info.getTxDate());
        }
        for (LocalDate date : set) {
            for (OverseaDetail info : detailList) {
                if (!info.getTxDate().equals(date) || !info.getNumber().equals(accNo)) continue;
                BigDecimal txAmt = info.getTxAmt();
                currentValue = "CREDIT".equals(info.getCordFlag()) ? currentValue.add(txAmt) : currentValue.subtract(txAmt);
                info.setBalance(currentValue);
            }
        }
    }
}

