/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.credit.open;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.credit.open.QueryOpenCreditImpl;
import kd.ebg.aqap.business.credit.EBGCreditUtils;
import kd.ebg.aqap.business.credit.openCredit.atomic.AbstractOpenCreditImpl;
import kd.ebg.aqap.business.credit.openCredit.atomic.IOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.atomic.IQueryOpenCredit;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OpenCreditImpl
extends AbstractOpenCreditImpl
implements IOpenCredit {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryOpenCredit> defaultQueryClass() {
        return QueryOpenCreditImpl.class;
    }

    public String pack(BankOpenCreditDetailRequest bankOpenCreditDetailRequest, String s) {
        List openCreditDetails = bankOpenCreditDetailRequest.getDetails();
        OpenCreditDetail openCreditDetail = (OpenCreditDetail)openCreditDetails.get(0);
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLIMCSUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)openCreditDetail.getDetailBizNo());
        JDomUtils.addChild((Element)root, (String)"ctfNum", (String)openCreditDetail.getApplicantCreditNum());
        JDomUtils.addChild((Element)root, (String)"channelFlag", (String)"XMGM");
        JDomUtils.addChild((Element)root, (String)"ltrcrCurr", (String)openCreditDetail.getCurrency());
        JDomUtils.addChild((Element)root, (String)"ltrcrAmt", (String)openCreditDetail.getAmount().toString());
        JDomUtils.addChild((Element)root, (String)"contractNo", (String)openCreditDetail.getContractNo());
        JDomUtils.addChild((Element)root, (String)"contractAmt", (String)openCreditDetail.getContractAmount().toString());
        JDomUtils.addChild((Element)root, (String)"letOfcreType", (String)openCreditDetail.getCreditType());
        JDomUtils.addChild((Element)root, (String)"isslcMode", (String)openCreditDetail.getCreditMode());
        JDomUtils.addChild((Element)root, (String)"letOfcreFrom", (String)openCreditDetail.getCreditForm());
        JDomUtils.addChild((Element)root, (String)"openDate", (String)openCreditDetail.getOpenDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"moreProportion", (String)openCreditDetail.getMoreProportion());
        JDomUtils.addChild((Element)root, (String)"lessProportion", (String)openCreditDetail.getLessProportion());
        JDomUtils.addChild((Element)root, (String)"letOfcreDueDate", (String)openCreditDetail.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"expAddress", (String)openCreditDetail.getDueAddress());
        JDomUtils.addChild((Element)root, (String)"custNmAdd", (String)openCreditDetail.getApplicantAddressEN());
        JDomUtils.addChild((Element)root, (String)"counterNmAdd", (String)openCreditDetail.getCounterAddress());
        JDomUtils.addChild((Element)root, (String)"mrgnPct", (String)openCreditDetail.getMrgnProportion());
        if (StringUtils.isNotEmpty((String)openCreditDetail.getMrgnProportion())) {
            JDomUtils.addChild((Element)root, (String)"mrgnAcc1Type", (String)openCreditDetail.getMrgnAccType());
            JDomUtils.addChild((Element)root, (String)"mrgnAcc1", (String)openCreditDetail.getMrgnAccno());
            JDomUtils.addChild((Element)root, (String)"mrgnAcc1Curr", (String)openCreditDetail.getMrgnCurrency());
        }
        JDomUtils.addChild((Element)root, (String)"charAccNo", (String)openCreditDetail.getCharAccNo());
        JDomUtils.addChild((Element)root, (String)"charCrytType", (String)openCreditDetail.getCharCurrency());
        JDomUtils.addChild((Element)root, (String)"costBear", (String)openCreditDetail.getCostBear());
        JDomUtils.addChild((Element)root, (String)"oprnm", (String)openCreditDetail.getOprNm());
        JDomUtils.addChild((Element)root, (String)"oprTel", (String)openCreditDetail.getOprTel());
        JDomUtils.addChild((Element)root, (String)"adviBankBIC", (String)openCreditDetail.getAdviCnapsCode());
        JDomUtils.addChild((Element)root, (String)"adviBankNmAdd", (String)openCreditDetail.getAdviAddress());
        JDomUtils.addChild((Element)root, (String)"avWtBank", (String)openCreditDetail.getAvWtBank());
        JDomUtils.addChild((Element)root, (String)"avWtBankBic", (String)openCreditDetail.getAvWtBankBic());
        JDomUtils.addChild((Element)root, (String)"avWtBankNmAdd", (String)openCreditDetail.getAvWtBankNmAdd());
        JDomUtils.addChild((Element)root, (String)"draftCustFlg", (String)openCreditDetail.getDraftCustFlg());
        JDomUtils.addChild((Element)root, (String)"tenorDays", (String)openCreditDetail.getPayDays());
        JDomUtils.addChild((Element)root, (String)"tenorType", (String)openCreditDetail.getPayType());
        JDomUtils.addChild((Element)root, (String)"forwardBankBIC", (String)openCreditDetail.getForwardCnapsCode());
        JDomUtils.addChild((Element)root, (String)"forwardBankNmAdd", (String)openCreditDetail.getForwardAddress());
        JDomUtils.addChild((Element)root, (String)"conInstructions", (String)openCreditDetail.getConInstructions());
        JDomUtils.addChild((Element)root, (String)"conInstructionsBic", (String)openCreditDetail.getAcceptorCnapsCode());
        JDomUtils.addChild((Element)root, (String)"conInstructionsNmAdd", (String)openCreditDetail.getAcceptorAddress());
        JDomUtils.addChild((Element)root, (String)"cashWay", (String)openCreditDetail.getCashWay());
        JDomUtils.addChild((Element)root, (String)"draftInvProportion", (String)openCreditDetail.getDraftProportion());
        JDomUtils.addChild((Element)root, (String)"draftInvAmt", (String)openCreditDetail.getDraftAmt().toString());
        if ("5".equals(openCreditDetail.getCashWay())) {
            JDomUtils.addChild((Element)root, (String)"mixDraftInvProportion", (String)openCreditDetail.getMixDraftInvProportion());
            JDomUtils.addChild((Element)root, (String)"mixDraftInvAmt", (String)openCreditDetail.getMixDraftInvAmt().toString());
            JDomUtils.addChild((Element)root, (String)"mixTenorType", (String)openCreditDetail.getMixTenorType());
        }
        JDomUtils.addChild((Element)root, (String)"mixTenorDays", (String)openCreditDetail.getMixTenorDays());
        JDomUtils.addChild((Element)root, (String)"durationDesc", (String)openCreditDetail.getExplain());
        JDomUtils.addChild((Element)root, (String)"draweeBankBic", (String)openCreditDetail.getDraweeCnapsCode());
        JDomUtils.addChild((Element)root, (String)"draweeBankNmAdd", (String)openCreditDetail.getDraweeAddress());
        JDomUtils.addChild((Element)root, (String)"isPartShip", (String)openCreditDetail.getIsPartShip());
        JDomUtils.addChild((Element)root, (String)"isTranShip", (String)openCreditDetail.getIsTranShip());
        JDomUtils.addChild((Element)root, (String)"shipDate", (String)openCreditDetail.getShipDate());
        JDomUtils.addChild((Element)root, (String)"presentPeriod", (String)openCreditDetail.getPresentPeriod());
        JDomUtils.addChild((Element)root, (String)"presentDay", (String)openCreditDetail.getPresentDay());
        JDomUtils.addChild((Element)root, (String)"deliveryPort", (String)openCreditDetail.getDeliveryPort());
        JDomUtils.addChild((Element)root, (String)"startAir", (String)openCreditDetail.getStartAir());
        JDomUtils.addChild((Element)root, (String)"terminiAir", (String)openCreditDetail.getTerminiAir());
        JDomUtils.addChild((Element)root, (String)"termini", (String)openCreditDetail.getTermini());
        JDomUtils.addChild((Element)root, (String)"GASDescription", (String)openCreditDetail.getGasDescription());
        JDomUtils.addChild((Element)root, (String)"docClause", (String)openCreditDetail.getDocClause());
        JDomUtils.addChild((Element)root, (String)"addClause", (String)openCreditDetail.getAddClause());
        JDomUtils.addChild((Element)root, (String)"remark", (String)openCreditDetail.getRemark());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<OpenCreditDetail> parse(BankOpenCreditDetailRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        if ("AAAAAAA".equals(statusText)) {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.SUBMITED, (String)status, (String)statusText);
        } else {
            EBGCreditUtils.setPaymentState((List)request.getDetails(), (PaymentState)PaymentState.UNKNOWN, (String)status, (String)statusText);
        }
        return request.getDetails();
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "DLIMCSUB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8fdb\u53e3\u4fe1\u7528\u8bc1\u5f00\u8bc1-\u7ecf\u529e", (String)"OpenCreditImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(OpenCreditDetail openCreditDetail) {
        return true;
    }
}

