/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.company.CompanyImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.income.IncomePayImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.individual.IndividualPaymentImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.individual.SinglePaymentImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.innerpay.InnerPayImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.intelligentpay.IntelligentPayImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.oversea.DLOUTSUBPayImpl;
import kd.ebg.aqap.banks.citic.dc.services.payment.salary.SalaryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.MatchTypeEnum;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.setPayRouteTrace(paymentInfo, this.getBusiImplInfo(paymentInfo));
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        String subBizType = paymentInfo.getSubBizType();
        if (this.isIncome(paymentInfo)) {
            this.setImplClassName(paymentInfo, IncomePayImpl.class.getName());
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo, busiImplInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
        } else if (this.isPay(paymentInfo)) {
            if (this.isSalaryUseCN(paymentInfo)) {
                this.setSubBizType4Salary(paymentInfo, busiImplInfo);
            } else if (this.isTransferUseCN(paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
            } else if (this.isAllTransfer()) {
                this.setImplClassName(paymentInfo, IntelligentPayImpl.class.getName());
            } else if (this.isIndividual(paymentInfo)) {
                if (!this.isSameBank(paymentInfo)) {
                    this.setImplClassName(paymentInfo, CompanyImpl.class.getName());
                } else if (this.isIndividualSinglePay()) {
                    this.setImplClassName(paymentInfo, SinglePaymentImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, IndividualPaymentImpl.class.getName());
                }
            } else {
                paymentInfo.setToIndividual("false");
                if (this.isMatchCompanyAcc(paymentInfo.getIncomeAccNo()) && paymentInfo.is2SameBank()) {
                    this.setImplClassName(paymentInfo, InnerPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, CompanyImpl.class.getName());
                }
            }
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, null);
            if (this.islinkpayToCompanyPay()) {
                this.setImplClassName(paymentInfo, CompanyImpl.class.getName());
            }
        } else if (this.isPay_for_overseaPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, DLOUTSUBPayImpl.class.getName());
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), subBizType));
        }
        busiImplInfo.setPackageKey("");
        return busiImplInfo;
    }

    public boolean isMatchCompanyAcc(String incomeAccNo) {
        boolean result = BankBusinessConfig.isMatchCompanyAcc(incomeAccNo);
        if (result) {
            this.addRoute(true, "citicb_dc_isInnerCompanyAcc", MatchTypeEnum.CONTAINS.getDesc(), incomeAccNo);
        }
        return result;
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        paymentInfo.setToIndividual("true");
        if (this.isSalaryPayToOther()) {
            this.setImplClassName(paymentInfo, IndividualPaymentImpl.class.getName());
        } else if (this.isSalaryPayToUnionPay()) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.citic.dc.services.payment.salary.newimpl.SalaryImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, SalaryImpl.class.getName());
        }
    }

    public boolean isSalaryPayToOther() {
        return this.assertBusinessConfig("citicb_dc_isSalaryPayToOhter", "true");
    }

    public boolean isSalaryPayToUnionPay() {
        return this.assertBusinessConfig("citicb_dc_isSalaryPayToOhter", "DLUPRSUB");
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        paymentInfo.setToIndividual("false");
        if (this.isAllocationToPayment("allTransfer")) {
            this.setImplClassName(paymentInfo, IntelligentPayImpl.class.getName());
        } else if (this.isAllocationToPayment("true")) {
            this.setImplClassName(paymentInfo, CompanyImpl.class.getName());
        } else {
            this.setImplClassNameCustom(paymentInfo, AllocationPayImpl.class.getName());
        }
    }

    public boolean isAllocationToPayment(String value) {
        return this.assertBusinessConfig("citicb_dc_allocationtopayment", value);
    }

    private boolean isIndividualSinglePay() {
        return this.assertBusinessConfig("citicb_dc_isIndividualSinglePay", "true");
    }

    public boolean isAllTransfer() {
        return this.assertBusinessConfig("citicb_dc_isAlltransfer", "true");
    }

    public boolean islinkpayToCompanyPay() {
        return this.assertBusinessConfig("citicb_dc_isLinkpayToCompany", "true");
    }

    public void setImplClassNameCustom(PaymentInfo paymentInfo, String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            String payBizCode = this.getTransferTypeOP(paymentInfo);
            paymentInfo.setImplClassName(className);
            this.addRoute(false, PayRouteEnum.IMPL.getDesc(), className);
            try {
                AbstractPayImpl pay = (AbstractPayImpl)Class.forName(className).newInstance();
                this.addRoute(false, PayRouteEnum.BANK_PAY_CODE.getDesc(), payBizCode);
                paymentInfo.setQueryImplClassName(pay.defaultQueryClass().getName());
                className = pay.defaultQueryClass().getName();
                this.addRoute(false, PayRouteEnum.QUERY_IMPL.getDesc(), className);
                try {
                    AbstractQueryPayImpl queryPay = (AbstractQueryPayImpl)Class.forName(className).newInstance();
                    String bankQueryPayCode = queryPay.getBizCode();
                    this.addRoute(false, PayRouteEnum.BANK_QUERY_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankQueryPayCode) ? "" : bankQueryPayCode);
                }
                catch (Exception var5) {
                    EBExceiptionUtil.serviceException((String)("QueryPayImpl = " + className + " is not found"), (Throwable)var5);
                }
            }
            catch (Exception var5) {
                EBExceiptionUtil.serviceException((String)("PayImpl = " + className + " is not found"), (Throwable)var5);
            }
        }
    }

    public String getTransferTypeOP(PaymentInfo paymentInfo) {
        if (this.isTransferUpUseCN(paymentInfo)) {
            return "CMMANSWP";
        }
        this.isTransferDownUseCN(paymentInfo);
        return "CMDWNSWP";
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Pretreatment";
    }

    public String getBizDesc() {
        return "Pretreatment";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

