/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.company;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.PaymentUtils;
import kd.ebg.aqap.banks.citic.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLOUTTRN";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"CompanyImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !BankBusinessConfig.isAllTransfer() && this.isCompany(paymentInfo);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bf9\u5916\u4ed8\u6b3e\u8f6c\u5e10(DLOUTTRN)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"CompanyImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLOUTTRN");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)root, (String)"abstract", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        LocalDateTime now = LocalDateTime.now();
        JDomUtils.addChild((Element)root, (String)"preDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"preTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
        BigDecimal amt = paymentInfo.getAmount();
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)root, (String)"payType", (String)"01");
        } else {
            root = this.fillBSPayType(root, amt);
        }
        JDomUtils.addChild((Element)root, (String)"payAccountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"recAccountNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)root, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)root, (String)"recOpenBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)root, (String)"recOpenBankCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)root, (String)"citicbankFlag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)root, (String)"cityFlag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)root, (String)"tranAmount", (String)amt.setScale(2, 4).toString());
        JDomUtils.addChild((Element)root, (String)"abstract", (String)BizNoUtil.cont((String)paymentInfo.getBankDetailSeqId(), (String)"\u2605", (String)PaymentUtils.getFixedExplanation(paymentInfo.getExplanation(), 92)));
        PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        JDomUtils.addChild((Element)root, (String)"memo", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)root, (String)"takerName", (String)"");
        JDomUtils.addChild((Element)root, (String)"takerID", (String)"");
        JDomUtils.addChild((Element)root, (String)"takerID", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2String((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parseBatchPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private Element fillBSPayType(Element element, BigDecimal amt) {
        BigDecimal BIG = new BigDecimal("50000");
        if (amt.compareTo(BIG) > 0) {
            JDomUtils.addChild((Element)element, (String)"payType", (String)"02");
        } else {
            JDomUtils.addChild((Element)element, (String)"payType", (String)"03");
        }
        return element;
    }
}

