/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.innerpay;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.innerpay.InnerQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InnerPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLINETRN";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5185\u90e8\u5e10\u8f6c\u8d26\u63a5\u53e3", (String)"InnerPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !BankBusinessConfig.isAllTransfer() && paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5185\u90e8\u8f6c\u8d26\u63a5\u53e3DLINETRN\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"InnerPayImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLINETRN");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)root, (String)"abstract", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        LocalDateTime now = LocalDateTime.now();
        JDomUtils.addChild((Element)root, (String)"preDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"preTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"memo", (String)paymentInfo.getUseCn());
        JDomUtils.addChild((Element)root, (String)"payAccountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"recAccountNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)root, (String)"tranAmount", (String)paymentInfo.getAmount().toString());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2String((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

