/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.oversea;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.PaymentUtils;
import kd.ebg.aqap.banks.citic.dc.services.payment.oversea.DLOUTAQYQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DLOUTSUBPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DLOUTSUBPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return DLOUTAQYQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String busCode = paymentInfo.getBusinessTypeCode();
        CountryISOCode payeeCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (null == payeeCode) {
            payeeCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        if (StringUtils.isEmpty((String)paymentInfo.getAccCountry())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u4ed8\u6b3e\u65b9\u8d26\u53f7\u6240\u5728\u56fd\u5bb6\u5730\u533a\u3002", (String)"DLOUTSUBPayImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        logger.info("\u4ed8\u6b3e\u65b9\u8d26\u53f7\u6240\u5728\u56fd\u5bb6\u5730\u533a {}", (Object)paymentInfo.getAccCountry());
        CountryISOCode payerCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (null == payerCode) {
            payerCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        boolean isOversea = !"CN".equalsIgnoreCase(payeeCode.geteChart2()) || !"CN".equalsIgnoreCase(payerCode.geteChart2());
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLOUTSUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)root, (String)"unitCode", (String)"734201");
        JDomUtils.addChild((Element)root, (String)"channelFlag", (String)"XMGM");
        JDomUtils.addChild((Element)root, (String)"bsnType", (String)paymentInfo.getBusinessTypeCode());
        boolean isoCurrency = CurrencyUtils.isISOCurrency((String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)root, (String)"outCryType", (String)(isoCurrency ? CurrencyUtils.convert2Bank((String)paymentInfo.getPayCurrency()) : paymentInfo.getPayCurrency()));
        JDomUtils.addChild((Element)root, (String)"outAmt", (String)paymentInfo.getAmount().toPlainString());
        if (Objects.isNull(paymentInfo.getBookingTime())) {
            JDomUtils.addChild((Element)root, (String)"valueDate", (String)paymentInfo.getRequestTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)root, (String)"valueDate", (String)paymentInfo.getBookingTime().format(DateTimeFormatter.BASIC_ISO_DATE));
            PaymentUtil.setBookPayFlag((List)paymentInfos);
        }
        JDomUtils.addChild((Element)root, (String)"remAccNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"remAccNo2", (String)"");
        String currency = bankPayRequest.getAcnt().getCurrency();
        currency = CurrencyUtils.convert2Bank((String)currency);
        JDomUtils.addChild((Element)root, (String)"remCryType", (String)currency);
        JDomUtils.addChild((Element)root, (String)"remCryType2", (String)"");
        JDomUtils.addChild((Element)root, (String)"etrnCurrAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)root, (String)"etrnCurrAmt2", (String)"");
        if ("4".equalsIgnoreCase(busCode) && !isOversea && !"CHN".equalsIgnoreCase(payeeCode.geteChart3())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u4e1a\u52a1\u7c7b\u578b\u4e3a\u540c\u540d\u5212\u8f6c\u3001\u5883\u5185\u5916\u6807\u8bc6\u4e3a\u5883\u5185\u65f6\uff0c\u6536\u6b3e\u4eba\u5e38\u9a7b\u56fd\u5bb6\u5fc5\u987b\u4e3aCHN-\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u3002", (String)"DLOUTSUBPayImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        if (isOversea && "CHN".equalsIgnoreCase(payeeCode.geteChart3())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5883\u5185\u5916\u6807\u8bc6\u4e3a\u5883\u5916\u65f6\uff0c\u6536\u6b3e\u4eba\u5e38\u9a7b\u56fd\u5bb6\u4e0d\u80fd\u662fCHN-\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd", (String)"DLOUTSUBPayImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"rcvPreCountry", (String)payeeCode.geteChart3());
        JDomUtils.addChild((Element)root, (String)"rBankAgeBIC", (String)paymentInfo.getProxyBankSwiftCode());
        JDomUtils.addChild((Element)root, (String)"rBankNmOfAdd", (String)"");
        JDomUtils.addChild((Element)root, (String)"rBankAcc", (String)paymentInfo.getProxyAccNo());
        JDomUtils.addChild((Element)root, (String)"rcvAcc", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)root, (String)"rcvNm", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)root, (String)"rcvAddress", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)root, (String)"rBankBIC", (String)paymentInfo.getIncomeSwiftCode());
        JDomUtils.addChild((Element)root, (String)"rBankAdd", (String)"");
        JDomUtils.addChild((Element)root, (String)"remPostscript", (String)paymentInfo.getExplanation());
        if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            JDomUtils.addChild((Element)root, (String)"declareNo", (String)"OUR");
        } else if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            JDomUtils.addChild((Element)root, (String)"declareNo", (String)"BEN");
        } else {
            JDomUtils.addChild((Element)root, (String)"declareNo", (String)"SHA");
        }
        String payProperty = PaymentUtils.checkout(paymentInfo.getPayProperty(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DLOUTSUBPayImpl_3", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        payProperty = Integer.parseInt(payProperty) + 1 + "";
        JDomUtils.addChild((Element)root, (String)"payType", (String)payProperty);
        JDomUtils.addChild((Element)root, (String)"charAccNo", (String)paymentInfo.getPayerFeeAccNo());
        if (StringUtils.isEmpty((String)paymentInfo.getPayerFeeCurrency())) {
            JDomUtils.addChild((Element)root, (String)"cryType", (String)"");
        } else {
            JDomUtils.addChild((Element)root, (String)"cryType", (String)CurrencyUtils.convert2Bank((String)paymentInfo.getPayerFeeCurrency()));
        }
        JDomUtils.addChild((Element)root, (String)"trxRemaPk1", (String)paymentInfo.getTxCode());
        JDomUtils.addChild((Element)root, (String)"corrAmt1", (String)paymentInfo.getAmount().setScale(0, 4).toPlainString());
        JDomUtils.addChild((Element)root, (String)"trxRemaPk2", (String)"");
        JDomUtils.addChild((Element)root, (String)"txnPscpt1", (String)paymentInfo.getTxPostscript());
        JDomUtils.addChild((Element)root, (String)"txnPscpt2", (String)"");
        JDomUtils.addChild((Element)root, (String)"corrAmt2", (String)"");
        JDomUtils.addChild((Element)root, (String)"contractNo", (String)paymentInfo.getContractNo());
        if ("1".equalsIgnoreCase(busCode) && StringUtils.isEmpty((String)paymentInfo.getInvoiceNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d38\u6613\u7684\u65f6\u9700\u4e0a\u9001\u53d1\u7968\u53f7\u3002", (String)"DLOUTSUBPayImpl_4", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"invoiceNo", (String)paymentInfo.getInvoiceNo());
        if ("4".equalsIgnoreCase(busCode) && isOversea) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u540c\u540d\u5212\u8f6c\u65f6,\u5883\u5185\u5916\u6807\u8bc6\u5fc5\u987b\u4e3a\u5883\u5185\u3002", (String)"DLOUTSUBPayImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"recformNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"froFlag", (String)(isOversea ? "1" : "2"));
        JDomUtils.addChild((Element)root, (String)"pdecNo", (String)"");
        if (isOversea) {
            JDomUtils.addChild((Element)root, (String)"payNature", (String)"");
        } else {
            JDomUtils.addChild((Element)root, (String)"payNature", (String)paymentInfo.getPayAttribute());
        }
        logger.info("\u662f\u5426\u4e3a\u4fdd\u7a0e\u8d27\u7269\u4e0b\u4ed8\u6b3e:{}", (Object)paymentInfo.isBondGoodsFlag());
        logger.info(PropertiesConstants.getValue((String)"YES"));
        logger.info(PropertiesConstants.getValue((String)"NO"));
        if ("1".equalsIgnoreCase(busCode)) {
            JDomUtils.addChild((Element)root, (String)"bondFlag", (String)(paymentInfo.isBondGoodsFlag() ? "1" : "2"));
        } else {
            JDomUtils.addChild((Element)root, (String)"bondFlag", (String)"");
        }
        if ("01".equalsIgnoreCase(paymentInfo.getPayerFeeType()) && ("USD".equalsIgnoreCase(paymentInfo.getPayCurrency()) || "EUR".equalsIgnoreCase(paymentInfo.getPayCurrency()))) {
            JDomUtils.addChild((Element)root, (String)"ovrchgFlg", (String)"2");
        } else {
            JDomUtils.addChild((Element)root, (String)"ovrchgFlg", (String)"");
        }
        if ("4".equalsIgnoreCase(busCode)) {
            JDomUtils.addChild((Element)root, (String)"nontradeType", (String)PropertiesConstants.getValue((String)"470QT"));
        } else {
            JDomUtils.addChild((Element)root, (String)"nontradeType", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"fileNm", (String)"");
        JDomUtils.addChild((Element)root, (String)"imageBatchId", (String)"");
        JDomUtils.addChild((Element)root, (String)"contacts", (String)"");
        JDomUtils.addChild((Element)root, (String)"contactNum", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        PayParserProxy.parsePay(bankPayRequest.getPaymentInfos(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "DLOUTSUB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6c47\u51fa\u6c47\u6b3e\u7ecf\u529e", (String)"DLOUTSUBPayImpl_6", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

