/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.dc.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class Tcommon {
    static EBGLogger log = EBGLogger.getInstance().getLogger(Tcommon.class);

    public static String createCommonMsg(String xml) {
        int digital = 8;
        String msgBody = xml;
        int msgBodyLen = Tcommon.getLength(msgBody);
        String msgHead = Tcommon.formatLen(String.valueOf(msgBodyLen), digital);
        return msgHead + msgBody;
    }

    public static int getLength(String str) {
        try {
            int length = str.getBytes(RequestContextUtils.getCharset()).length;
            return length;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u51fa\u9519\uff1a" + str + ", encoding:" + RequestContextUtils.getCharset(), (Throwable)e);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)RequestContextUtils.getCharset());
        }
        catch (Exception e) {
            log.error("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\u3002", (Throwable)e);
            return "";
        }
    }

    private static byte[] read(DataInputStream dis, int length) {
        byte[] bytes = new byte[length];
        try {
            int result = dis.read(bytes);
            if (result - length != 0) {
                log.info("\u76ee\u6807\u8bfb\u53d6\u957f\u5ea6:" + length + ", \u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + result);
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6d41\u5931\u8d25\uff0cIOException %1$s\u3002", (String)"Tcommon_5", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return bytes;
    }

    private static String read2String(DataInputStream dis, int length, String encoding) {
        try {
            String str = new String(Tcommon.read(dis, length), encoding);
            str = StringUtils.isEmpty((String)str) ? "" : str.trim();
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301%1$s\u5b57\u7b26\u7f16\u7801\u3002", (String)"Tcommon_6", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), encoding), (Throwable)e);
        }
    }

    public static String recvMessage(InputStream inputStream) {
        String encoding = RequestContextUtils.getCharset();
        try {
            DataInputStream dis = new DataInputStream(inputStream);
            String length = Tcommon.read2String(dis, 8, encoding);
            int len = Integer.parseInt(length);
            String str = Tcommon.read2String(dis, 2, encoding);
            String xmlString = Tcommon.read2String(dis, len - 2, encoding);
            log.info("##\u63a5\u6536\u62a5\u6587\u957f\u5ea6\uff1a" + length + ", \u62a5\u4f53\u524d\u4e24\u5b57\u8282\uff1a" + str + ", \u62a5\u4f53\u5185\u5bb9\uff1a" + xmlString);
            return xmlString;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String parseRecvMsg(String input) {
        log.info("###recv data\uff1a" + input);
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }

    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        String ext_info = head.getChildTextTrim("ext_info");
        String responseMessage = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%1$s\u3002", (String)"Tcommon_7", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), ret_info);
        if (!StringUtils.isEmpty((String)ext_info)) {
            responseMessage = responseMessage + String.format(ResManager.loadKDString((String)"\uff1b\u94f6\u884c\u8fd4\u56de\u9644\u52a0\u4fe1\u606f\uff1a%1$s", (String)"Tcommon_8", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]), ext_info);
        }
        response.setResponseCode(succ_flag + "_" + ret_code);
        response.setResponseMessage(responseMessage);
        return response;
    }
}

